/* 
 * http-redir : redirecteur http
 * Copyright (C) 2002 Stephane Marchesin
 * 
 * http://dea-dess-info.u-strasbg.fr/~marchesin/"
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <unistd.h>
#include <netinet/in.h>

// l'url vers laquelle on va rediriger...
#define URL_REDIR "http://dea-dess-info.u-strasbg.fr/~marchesin/"

static void sigchld_handler(int dum)
{
	while(waitpid(-1,NULL,WNOHANG)>0);
}

static void sigalrm_handler(int dum)
{
	kill(getpid(),SIGKILL);
}

void main (int argc, char **argv)
{
	struct sockaddr_in addr, addrfrom;
	int laddr;
	int sd;
	struct sigaction act_chld={sigchld_handler,0,SA_NOCLDSTOP|SA_RESTART,NULL};
	struct sigaction act_alrm={sigalrm_handler,0,SA_NOCLDSTOP|SA_RESTART,NULL};
	
	sigaction(SIGCHLD,&act_chld,NULL);
	sigaction(SIGALRM,&act_alrm,NULL);
	
	addr.sin_family = AF_INET;
	addr.sin_port = htons (atoi (argv[1]));
	addr.sin_addr.s_addr = htonl (INADDR_ANY);

	sd = socket (AF_INET, SOCK_STREAM, 0);
	bind (sd, (struct sockaddr *) (&addr), sizeof (addr));
	listen (sd, 16);
	while (1)
	{
		int ss;		// socket de service 
		pid_t p;
		laddr = sizeof (addrfrom);
		ss = accept (sd, &addrfrom, &laddr);
		p = fork ();
		if (p == 0)
		{		
			// on est dans le processus fils
			char* html_header="HTTP/1.0 200 OK\r\nContent-Type: text/html\r\n\r\n";
			char* html_body="<html><head><title>Redirection...</title></head><body><a href="URL_REDIR">Redirection</a><META HTTP-EQUIV=\"Refresh\" CONTENT=\"0; URL="URL_REDIR"\"></body></html>\r\n\r\n";
			char* html_end="HTTP/1.0 200 OK\r\nConnexion: Close\r\n\r\n";
			char newc, oldc;
			int nbuf,size;
			
			// ce message s'autodetruira dans 10 secondes
			alarm(10);
			
			close (sd);
			oldc = 0;
			nbuf = 0;
			do
			{
				size = read (ss, &newc, 1);
				nbuf += size;
				if (((newc =='\n') && (oldc == '\n'))||((newc =='\r') && (oldc == '\n')))
					break;
				oldc = newc;
			}
			while ((nbuf<1000)&&(size>0));
			
			if (size<0) 
				goto the_end;
			
			if (write (ss, html_header, strlen (html_header))<0) 
				goto the_end;
			if (write (ss, html_body, strlen (html_body))<0)
				goto the_end;
		
			oldc = '\n';
			nbuf = 0;
			do
			{
				size = read (ss, &newc, 1);
				nbuf += size;
				if (((newc =='\n') && (oldc == '\n'))||((newc =='\r') && (oldc == '\n')))
					break;
				oldc = newc;
			}
			while ((nbuf<100)&&(size>0));
			
			// s'il rate c'est pas grave, c'est le dernier
			write (ss, html_body, strlen (html_end));
			
			the_end:
			close (ss);
			
			exit (0);
		}
		close (ss);
	}
	close (sd);
}
