#include <stdlib.h>
#include <stdio.h>
#include "types.h"
#include "affiche.h"
#include "casteljau.h"
#include "liste.h"

// la liste des points de controle
liste<point> l;

// est-ce qu'on doit rafraichir ?
bool afficher = true;

void affiche()
{
	printf("affiche\n");
	fenetre.efface();
	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable (GL_LINE_SMOOTH);
	glEnable (GL_POLYGON_SMOOTH);
	glEnable (GL_BLEND);
	glDisable(GL_TEXTURE_2D);

	
	float pas=0.2;
	point p;
	glColor3ub(0,0,255);
	glBegin(GL_LINE_STRIP);
	for(float f=0.0f;f<=1.0f;f+=pas)
	{
		p=casteljau(f,l);
		glVertex2f(p.coord_x(),p.coord_y());
		
	}
	glEnd();
	
	pas=0.05;
	glColor3ub(255,0,0);
	glBegin(GL_LINE_STRIP);
	for(float f=0.0f;f<=1.0f;f+=pas)
	{
		p=casteljau(f,l);
		glVertex2f(p.coord_x(),p.coord_y());
		
	}
	glEnd();
	
	pas=0.005;
	glColor3ub(0,255,0);
	glBegin(GL_LINE_STRIP);
	for(float f=0.0f;f<=1.0f;f+=pas)
	{
		p=casteljau(f,l);
		glVertex2f(p.coord_x(),p.coord_y());
		
	}
	glEnd();
	
	fenetre.flush();
}

// les handlers

// handler affichage
void display ()
{
	afficher = true;
}

// le handler pour resize
void reshape (int x, int y)
{
}

// le handler pour rafraichssement
void visibility (int dum1)
{
	afficher = true;
}

// le handler pour les touches
void keyboard (unsigned char dum, GLint touche, GLint s_c)
{
	exit(0);
}

void idle ()
{
	if (afficher)
	{
		affiche();
		afficher = false;
	}
	else
		usleep (100);
}

// le handler pour la souris
void mouse (int button, int state, int x, int y)
{
	if (state==1)
	{
		fenetre.clic(x,y);
		afficher = true;
	}
}

int main (int argc, char ** argv)
{
	l.adjq(point(0,0));
	l.adjq(point(200,200));
	l.adjq(point(400,200));
	l.adjq(point(400,400));
	l.adjq(point(100,400));
	l.adjq(point(640,400));
	l.adjq(point(400,0));
	
	fenetre.creer (1024, 768,"Casteljau");

	// mise en place des handlers
	glutVisibilityFunc (visibility);
	glutReshapeFunc (reshape);
	glutDisplayFunc (display);
	glutKeyboardFunc (keyboard);
	glutMouseFunc (mouse);
	glutIdleFunc (idle);

	// donner la main  glut
	glutMainLoop ();
	
	// pour faire plaisir  gcc
	return 0;
}

