//#include "liste.h"

#include <string.h>

// constructeur liste vide
template <class element>
liste<element>::liste ()
{
	taille = 0;
	nb_elem = 0;
	la_liste = NULL;
}

// constructeur avec un entier
template <class element>
liste<element>::liste (element i)
{
	taille = 10;
	nb_elem = 1;
	la_liste = (element **) malloc (10 * sizeof (element*));
	la_liste[0] = new element (i);
	for (unsigned int i = 1; i < 10; i++)
		la_liste[i] = NULL;
}


// cdc 
template <class element>
liste<element>::liste (const liste & l)
{
	this->taille = l.taille;
	this->nb_elem = l.nb_elem;
//	if (this->la_liste != NULL)
//		free (la_liste);
	if (l.la_liste != NULL)
	{
		this->la_liste = (element **) malloc (l.taille * sizeof (element*));
		for (unsigned int i = 0; i < l.nb_elem; i++)
			la_liste[i] = new element ((*l.la_liste[i]));
		for (unsigned int i = l.nb_elem; i < l.taille; i++)
			la_liste[i] = NULL;
	}
	else
		this->la_liste = NULL;
}

// destructeur
 
template <class element>
liste<element>::~liste ()
{
	for (unsigned int i = 0; i < taille; i++)
		if (la_liste[i] != NULL)
			delete (la_liste[i]);
	free (la_liste);
	taille = 0;
	nb_elem = 0;
	la_liste = NULL;
}

// affectation 
template <class element>
void liste<element>::operator = (const liste & l)
{
	this->taille = l.taille;
	this->nb_elem = l.nb_elem;
//	if (this->la_liste != NULL)
//		free (la_liste);
	if (l.la_liste != NULL)
	{
		this->la_liste = (element **) malloc (l.taille * sizeof (element*));
		for (unsigned int i = 0; i < l.nb_elem; i++)
			la_liste[i] = new element ((*l.la_liste[i]));
		for (unsigned int i = l.nb_elem; i < l.taille; i++)
			la_liste[i] = NULL;
	}
	else
		this->la_liste = NULL;
}

// adjonction en queue 
template <class element>
void liste<element>::adjq (element i)
{
	if (nb_elem == taille)
	{
		taille += 10;
		la_liste = (element **) realloc (la_liste, taille * sizeof (element*));
	}
	la_liste[nb_elem] = new element (i);
	nb_elem++;
	for (unsigned int i = nb_elem; i < taille; i++)
		la_liste[i] = NULL;
}

// vide la liste
template <class element>
void liste<element>::vide ()
{
	for (unsigned int i = 0; i < taille; i++)
		if (la_liste[i] != NULL)
			delete (la_liste[i]);
	taille = 0;
	nb_elem = 0;
	free (la_liste);
	la_liste = NULL;
}

template <class element>
element & liste<element>::operator[] (unsigned int i)
{
	return (*la_liste[i]);
}

// test d'appartenance d'un lment 
template <class element>
bool liste<element>::app (element i)
{
	unsigned int j = 0;

	if (nb_elem == 0)
		return false;
	while (j < nb_elem)
	{
		if ((*la_liste[j]) == i)
			return true;
		else
			j++;
	}
	return false;
}
 
template <class element>
void liste<element>::concat (liste & l)
{
	taille += l.taille;
	la_liste = (element **) realloc (la_liste, taille * sizeof (element*));
	for (unsigned int i = 0; i < l.nb_elem; i++)
	{
		la_liste[nb_elem] = new element ((*l.la_liste[i]));
		nb_elem++;
	}
	for (unsigned int i = nb_elem; i < taille; i++)
		la_liste[i] = NULL;              	
}

// ecrit la liste dans un fichier
template <class element>
void liste<element>::ecrit (char* nom)
{
	FILE* f;
	f=fopen(nom,"w+");
	if (f==NULL) 
	{	
		printf("erreur d'ouverture de %s\n",nom);
		return;
	}
		
	for(unsigned int i=0;i<nb_elem;i++)
		fprintf(f,"%d\t%f\n",i,operator[](i));
	fclose(f);
}

