// affiche.c : implantation des routines d'affichage

#include "types.h"
#include "affiche.h"

Cfenetre fenetre;

// rececption d'un clickliquable
void Cfenetre::clic(int x, int y)
{
}


// constructeur
Cfenetre::Cfenetre ()
{
}

void Cfenetre::affiche()
{
	efface();
	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable (GL_LINE_SMOOTH);
	glEnable (GL_POLYGON_SMOOTH);
	glEnable (GL_BLEND);
	glDisable(GL_TEXTURE_2D);
	flush();
}

// creer une fenetre de taille (x,y)
void Cfenetre::creer (int x, int y,char* nom)
{
	glutInitWindowPosition (50, 50);
	glutInitWindowSize (x, y);
	glutInitDisplayMode ((GLenum) GLUT_RGB | GLUT_DOUBLE);
	glutCreateWindow (nom);
	glClearColor (1.0, 1.0, 1.0, 0.0);
	glViewport (0, 0, x, y);
	glMatrixMode (GL_PROJECTION);
	glLoadIdentity ();
	glMatrixMode (GL_MODELVIEW);
	glLoadIdentity ();
	glClear (GL_COLOR_BUFFER_BIT);
	glDisable (GL_DITHER);
	glOrtho (0.0, (float) 640, 0.0, (float) 480, -1.0, 1.0);
	glTranslatef (0.375f, 0.375f, 0.0f);
	glFlush ();
	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable (GL_LINE_SMOOTH);
	glEnable (GL_POLYGON_SMOOTH);
	glEnable (GL_BLEND);
	fenetre_x=x;
	fenetre_y=y;
}


void Cfenetre::cercle(float x,float y,float ra,unsigned char r,unsigned char v, unsigned char b,unsigned char a)
{
	glLineWidth(2.0f);
	glColor4ub(r,v,b,a);
	const unsigned int subdiv=12;
	
	glBegin(GL_LINE_LOOP);
	for(unsigned int i=0;i<=subdiv;i++)
	{
		double angle=((float)i)/(float)subdiv*2.0f*M_PI;
		glVertex2f(x+ra*cos(angle),y+ra*sin(angle));
	}
	glEnd();
}

void Cfenetre::ligne(float x1,float y1,float x2,float y2,unsigned char r,unsigned char v, unsigned char b,unsigned char a,float f)
{
	glColor4ub(r,v,b,a);
	glLineWidth(f);
	
	glBegin(GL_LINES);
	glVertex2f(x1,y1);
	glVertex2f(x2,y2);
	glEnd();
}

void Cfenetre::flush()
{
	glFinish();
	glutSwapBuffers ();
}

void Cfenetre::efface()
{
	glClear(GL_COLOR_BUFFER_BIT);
}

