#ifndef __screen_h_
#define __screen_h_

#include "x11.h"
#include "main.h"

/**
* Screen information.
*/
typedef struct ScreenInfo ScreenInfo;
struct ScreenInfo {
	Window root;
	Window popup;
	
	int display_width;		/* The width of the screen. */
	int display_height;		/* The height of the screen. */
	
	GC gc;		/* The default GC. */
	GC gc_thin;	/* The default GC but with thinner lines. */
	GC menu_gc;	/* The GC for the popup window (menu). */
	GC size_gc;	/* The GC for the popup window (sizing). */
	
	unsigned long black;		/* Black pixel value. */
	unsigned long white;	/* White pixel value. */
	
	Cursor root_cursor;
	Cursor frame_cursor;
	
	Cursor cursor_map[E_LAST];
	
	char * display_spec;
};

#endif

