/*
	For more information on lwm, see

		http://users.ch.genedata.com/~enh/

*/

#ifndef __main_h_
#define __main_h_

#define HIDE_BUTTON Button3
#define MOVE_BUTTON Button2
#define RESHAPE_BUTTON Button1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

#define true (0==0)
#define false (!true)

#define CREATE_SHAPE ShapeSubtract
#define DESTROY_SHAPE ShapeUnion

/* --- End of administrator-configurable defaults. --- */


/*
 * Window manager mode. wm is in one of three modes: it's either getting
 * user input to move/reshape a window, getting user input to make a
 * selection from the menu, or it's `idle' --- responding to events arriving
 * from the server, but not directly interacting with the user.
 * OK, so I lied: there's a fourth mode so that we can tell when wm's still
 * initialising.
 */
typedef enum {
	wm_initialising, wm_idle, wm_reshaping, wm_menu_up
} Mode;

/** Window internal state. Yuck. */
typedef enum {
	IPendingReparenting, INormal
} IState ;

/**
* Window edge, used in resizing. The `edge' ENone is used to signify a
* window move rather than a resize. The code is sufficiently similar that
* this isn't a special case to be treated separately.
*/
typedef enum {
	ETopLeft,	ETop,		ETopRight,
	ERight,		ENone,		ELeft,
	EBottomLeft,	EBottom,	EBottomRight,
	E_LAST
} Edge ;

#endif

