#include	"error.h"
#include	"lwm.h"

int ignore_badwindow;

void
panic(char *s) {
	fprintf(stderr, "%s: %s\n", argv0, s);
	exit(EXIT_FAILURE);
}

int
errorHandler(Display *d, XErrorEvent *e) {
	char	msg[80];
	char	req[80];
	char	number[80];

	if (mode == wm_initialising &&
		 e->request_code == X_ChangeWindowAttributes &&
		 e->error_code == BadAccess)
			panic("another window manager is already running.");

	if (ignore_badwindow &&
	    (e->error_code == BadWindow || e->error_code == BadColor))
			return 0;

	XGetErrorText(d, e->error_code, msg, sizeof(msg));
	sprintf(number, "%d", e->request_code);
	XGetErrorDatabaseText(d, "XRequest", number, number, req, sizeof(req));

	fprintf(stderr, "%s: protocol request %s on resource %#x failed: %s\n",
		argv0, req, (unsigned int) e->resourceid, msg);

	if (mode == wm_initialising)
		panic("can't initialise.");

	return 0;
}
