#ifndef __client_h_
#define __client_h_

#include "screen.h"

typedef struct Client Client;
struct Client {
	Window window;		/* Client's window. */
	Window parent;		/* Window manager frame. */
	Window trans;			/* Window that client is a transient for. */

	Client * next;			/* Next window in client list. */
	int tab_width;			// this window's tab width, ie the width of written part of the yellow thing
	int tab_xpos;			// the tab's xpos
	
	int border;			/* Client's original border width. */

	XSizeHints size;		/* Client's current geometry information. */
	int state;				/* Window state. See ICCCM and <X11/Xutil.h> */

	Bool hidden;			/* True if this client is hidden. */
        Bool close_pending;
	IState internal_state;
	int proto;

	int accepts_focus;		/* Does this window want keyboard events? */
	
	char * name;			/* Name used for title in frame. */
	char * fallback_name;	/* Name used in menu when window has no titlebar. */
	
	char tab_needs_rendering;	// the tab needs rendering
	char active;			// is the window active ?
	
	Pixmap tab_pixmap;	// the tab's pixmap
	
	Pixmap p,dr,dl,ur,ul;
	
	ScreenInfo * screen;
	
	/* Colourmap scum. */
	Colormap cmap;
	int ncmapwins;
	Window * cmapwins;
	Colormap * wmcmaps;
};


/*
 *	c->proto is a bitarray of these
 */
enum {
	Pdelete = 1,
	Ptakefocus = 2
};

/*	client.c */
extern Edge interacting_edge;
extern Bool close_pending;
extern Client *Client_Get(Window);
extern Client *Client_Add(Window, Window);
extern void Client_MakeSane(Client *, Edge, int *, int *, int *, int *);
extern void Client_DrawBorder(Client *, int);
extern void setactive(Client *, int, long);
extern void Client_SizeFeedback(void);
extern void size_expose(void);
extern void Client_ReshapeEdge(Client *, Edge);
extern void Client_Move(Client*);
extern void Client_SetState(Client *, int);
extern void Client_Back(Client *);
extern void Client_Close(Client *);
extern void Client_Close_Pend(Client *);
extern void Client_Remove(Client *);
extern void Client_FreeAll(void);
extern void Client_ColourMap(XEvent*);
extern int hidden(Client *);
extern int withdrawn(Client *);
extern int normal(Client *);
extern Client *current;


#endif

