/* test du package arithmetique */

#include <stdio.h>

#include "assert.h"
#include "arithmetique.h"

/* tirage aleatoire de TEST_NUMBER paires de nombres entiers et verification
 * des predicats arithmetiques sur la division, le modulo et le pgcd
 */
main()
{
#define TEST_NUMBER 10000
    int i; /* compte de tests */
    int a, b; /* paire a tester */
    int quotient, mod, gcd; /* resultats */

    for(i=0; i<TEST_NUMBER; i++) {
	/* calcul de la paire aleatoire */
	/* rand renvoie une valeur positive */
	a = (int) rand() - 16384;
	/* recherche d'un b non nul */
	for(b = 0; b==0; b = (int) rand() - 16384)
	    ;

	/* appel des fonctions a tester */
	quotient = divide(a,b);
	mod = modulo(a,b);
	gcd = pgcd_fast(a,b);
	
	/*
	 * printf("essai %d\ta=%d\tb=%d\tq=%d\tr=%d\tgcd=%d\tgcdr=%d\n",
	 *        i,a,b,quotient,mod,gcd,pgcd_slow(a,b));
	 */

	/* concordance des deux versions du calcul du pgcd */
	assert(gcd == pgcd_slow(a,b));

	/* definition de la division entiere a reste positif */
	assert(b*quotient+mod==a);
	assert(mod>=0);
	assert(mod<b);

	/* definition du pgcd */
	assert(modulo(a,gcd)==0);
	assert(modulo(b,gcd)==0);
	assert(pgcd_fast(divide(a,gcd),divide(b,gcd))==1);
	assert(gcd>0);
    }
}
