/************************************************/
/*  eval_ehrhart.c                              */
/* functions to evaluate an Ehrhart polynomial. */
/* written by Emmanuel Jeannot (c) 1997.        */
/*  Emmanuel.Jeannot@ens-lyon.fr                */
/*  http://www.ens-lyon.fr/~ejeannot            */
/************************************************/

#ifndef _EVAL_EHRHART_H_
#define _EVAL_EHRHART_H_

#include "arithmetique.h"
#include "types-polylib.h"
#include "ehrhart.h"
#include <string.h>

/* evaluate an evalue for the given parameters */
double compute_evalue(evalue *, Value*);

/* For the given parameters,                      */
/* -check for validity domain in the enumeration, */
/* -compute the ehrhart polynomial                */
Value compute_poly(Enumeration *en, Value *);


#endif /* _EVAL_EHRHART_H_ */
