#include <stdio.h>
#include "types.h"
#include "vector.h"
#include "polyhedron.h"


/* Matrix *Bounding_Box( Polyhedron *P )
	Construit une matrice contenant les contraintes de la
	bounding box de P, de la forme :
	   1  den_min_i 0   ...      0 -num_min_i
	   1 -den_max_i 0   ...      0  num_max_i
	   1     0   den_min_j 0 ... 0 -num_min_j
	   1     0  -den_max_j 0 ... 0  num_max_j
      .     .      .        ...        .

	Renvoie NULL si P est infini dans une direction ou si P est vide.
*/
Matrix *Bounding_Box( Polyhedron *P )
{
	int r, i;		/* ray, index */
	Matrix *C;		/* constraints matrix */
	Polyhedron *pp; /* polyhedron scanned */
	int d;			/* dimension */

	while( P )
	{
		if( P->NbRays != 0 )
			break;
		P = P->next;
	}
	if( !P )
		return( NULL );	/* empty polyhedron ! */

	d = P->Dimension;
	C = Matrix_Alloc( d*2, d+2 );
	memset( &C->p[0][0], 0, sizeof(int)*d*2*(d+2) );

	for( i=0 ; i<d ; ++i )
	{
		C->p[2*i][0] = 1;
		C->p[2*i+1][0] = 1;

		C->p[2*i][i+1] = P->Ray[0][d+1];	/* denom. */
		C->p[2*i][d+1] = -P->Ray[0][i+1];	/* num. */

		C->p[2*i+1][i+1] = -P->Ray[0][d+1];
		C->p[2*i+1][d+1] = P->Ray[0][i+1];
	}

	for( pp=P ; pp ; pp=pp->next )
	{
		for( r=0 ; r<pp->NbRays ; ++r )
		{
			if( pp->Ray[r][0] == 0 )
			{
				Matrix_Free( C );
				return( NULL );	/* infinite polyhedron */
			}
			for( i=0 ; i<d ; ++i )
			{
				/* nouveau min ? */
				if( -C->p[2*i][d+1]*pp->Ray[r][d+1] >
							pp->Ray[r][i+1]*C->p[2*i][i+1] )
				{	/* oui */
					C->p[2*i][d+1] = -pp->Ray[r][i+1];
					C->p[2*i][i+1] = pp->Ray[r][d+1];
				}
				/* nouveau max ? */
				if( C->p[2*i+1][d+1]*pp->Ray[r][d+1] <
							-pp->Ray[r][i+1]*C->p[2*i+1][i+1] )
				{	/* oui */
					C->p[2*i+1][d+1] = pp->Ray[r][i+1];
					C->p[2*i+1][i+1] = -pp->Ray[r][d+1];
				}
			}
		}
	}

	return( C );
}

