/*       Intersection of many domains. give the number of domains as first input
*/

#include <stdio.h>
#include <stdlib.h>
#include "types.h"
#include "vector.h"
#include "polyhedron.h"

int main()
{
	Matrix *a;
	Polyhedron *I=NULL;
	int np, i;
	Polyhedron *P;

	scanf( "%d", &np );
	
	for( i=0 ; i<np ; ++i )
	{
		a = Matrix_Read();
		P = Constraints2Polyhedron(a, 20000);
		Matrix_Free(a);
		if( !I )
			I = P;
		else
		{
			I = DomainIntersection( I, P, 20000);
			Domain_Free( P );
		}
	}

	Polyhedron_Print( stdout, "%3d ", I );

	printf( "\nCONSTRAINT MATRIX :\n" );
	a = Polyhedron2Constraints(I);
	Matrix_Print( stdout, "%3d ", a );

	Domain_Free(I);
	return 0;
}
