/* gtk_ddraw.c
     COPYRIGHT
          Both this software and its documentation are
 
              Copyrighted 1997 by Vincent Loechner.
	      GTK Code 1999 by Stephane Genaud.

          Permission is granted to copy, use, and distribute
          for any commercial or noncommercial purpose under the terms
          of the GNU General Public license, version 2, June 1991
          (see file : LICENSING).
*/
/* fonctions de dessin fenetre domaine */

#ifndef _X_DOMAIN_DRAW_H
#define _X_DOMAIN_DRAW_H

#include <gtk/gtk.h>
#include <polylib/polylib32.h>

#define WS 1000


typedef struct face
{
        struct face *next;
        int Epaisseur;          /*      signee : first >0 , last <0 */
        Polyhedron *P;          /*      Cette face. (optimisation dessin) */
}
Faces;
 
typedef struct point
{       float x, y; }
Point;

extern GdkFont *font;
extern GdkGC *whitePen;
extern GdkGC *bluePen; 
 
extern GdkGC *GetPen (int nRed, int nGreen, int nBlue);
extern void init_Colors();
extern Faces *CalcFaces( Polyhedron * );
extern void FreeFaces( Faces * );
extern void DLine( GdkDrawable *pixmap, Point, Point );
extern void DPoint( GdkDrawable *pixmap, Point,GdkGC *couleur);
extern void Calc_Extr( );
extern Point ProjectionPoint( int *, int );
extern Point ProjectionPointEntier( int *, int );
extern int Draw_Int_Points( GdkDrawable *pixmap, Polyhedron *,GdkGC *couleur);
extern void Draw_Faces( GdkDrawable *pixmap, Faces *, int, int );
extern void Draw_Domain(GdkDrawable *pixmap, Polyhedron *P, GdkGC *couleur, int r );
extern void Draw_Polyedre(GdkDrawable *pixmap, Polyhedron *P, GdkGC *couleur, int r );
extern void Draw_Polyhedre_Plat(GdkDrawable *pixmap, Polyhedron *P, GdkGC *couleur, int f);
extern void Draw_Polygone(GdkDrawable *pixmap,Point *pt, int npoints,GdkGC *couleur,int mode_plein);
extern void Draw_Activation_Points( GdkDrawable *pixmap, Polyhedron *, int );
extern void AffPoint(GdkDrawable *pixmap, int *pt, GdkGC *couleur);

#endif
