/* gtk_ddraw.c
     COPYRIGHT
          Both this software and its documentation are
 
              Copyrighted 1997 by Vincent Loechner.
	      GTK Code 1999 by Stephane Genaud.

          Permission is granted to copy, use, and distribute
          for any commercial or noncommercial purpose under the terms
          of the GNU General Public license, version 2, June 1991
          (see file : LICENSING).
*/

#include <gtk/gtk.h>
#include <gdk/gdk.h>

#include <math.h>

#include <polylib/polylib64.h>

#include "gtk_windows.h"
#include "gtk_domain.h"
#include "gtk_repere.h"
#include "domains.h"
#include "gtk_ddraw.h"

/* #define SPRINT */


GdkGC *whitePen = NULL;
GdkGC *bluePen = NULL;
GdkGC *blackPen = NULL;

GdkFont *font;

/************************************************************************/
/* GetPen() : addendum. used to change the color of the items being 	*/
/* drawn on the domain window (it is based on the gc created for this 	*/
/* window). The color is a (R,G,B) 3-uple.				*/
/************************************************************************/
GdkGC *GetPen (int nRed, int nGreen, int nBlue)
{
  GdkColor *c;
  GdkGC *gc;

  c = (GdkColor *) g_malloc (sizeof (GdkColor));
  c->red = nRed;
  c->green = nGreen;
  c->blue = nBlue;
  gdk_color_alloc (gdk_colormap_get_system (), c);
  gc = gdk_gc_new (dg);		/* dg is the backing pixmap for the domain window */
  gdk_gc_set_foreground (gc, c);
  return (gc);
}

/************************************************************************/
/* init_Colors()							*/
/************************************************************************/
void init_Colors ()
{
  whitePen = GetPen (0xffff, 0xffff, 0xffff);
  bluePen = GetPen (0, 0, 0xffff);
  blackPen = GetPen (0, 0, 0);

  /* --- Get a font --- temporaire : recharge fonte  chaque fois */
  font =
    gdk_font_load ("-adobe-helvetica-medium-r-normal--*-120-*-*-*-*-*-*");
  if (font == NULL)
    {
      fprintf (stderr, "NULL font, trying another\n");
      font = gdk_font_load ("-adobe-helvetica-*-120-*-*-*-*-*-*");
    }
}

/************************************************************************/
/* AffPoint()								*/
/* projette et affiche le point pt  					*/
/************************************************************************/
void AffPoint (GdkDrawable * pixmap, Value * pt, GdkGC * couleur)
{
  Point xypt;

  xypt = ProjectionPointEntier (pt, DimNP);
  DPoint (pixmap, xypt, couleur);
}

static GdkDrawable *_dipD;
static GdkGC *_dipC;
static Domain *_dipDomain;
/************************************************************************/
/* _dip()								*/
/* projette et affiche le point pt  					*/
/************************************************************************/
static int _dip (Value * pt)
{
  Point xypt;
  Domain *Dcur;
  GdkGC *Color;
  gushort r, g, b;
  int n;
  
  if (!_dipDomain->visual)
     /* Paranoa: cela ne doit jamais arriver! */
     return 0;
  
  n = 1;
  r = _dipDomain->color->red;
  g = _dipDomain->color->green;
  b = _dipDomain->color->blue;
  Dcur = DomainList;
  while (Dcur)
  {
     if ((strcmp (Dcur->name, _dipDomain->name) != 0)
         && (Dcur->visual) && (Dcur->visual->intpoints))
        {
	 if (DansDomaine (Dcur->visual->NPdomain, pt))
	   {
	    /*   Le point appartient galement  un autre domaine dont les */
	    /* points entiers sont affichs, il faut modifier sa couleur.  */ 
	    n++;
	    r = r * (n - 1) / n + Dcur->color->red / n;
	    g = g * (n - 1) / n + Dcur->color->green / n;
	    b = b * (n - 1) / n + Dcur->color->blue / n;	    
	    }
	 }
     Dcur = Dcur->next;
     }
  xypt = ProjectionPointEntier (pt, DimNP);
  Color = GetPen (r, g, b);
  DPoint (_dipD, xypt, Color);
  return 1;
}

/************************************************************************/
/*  Draw_Int_Points()							*/
/* Dessine les points entiers dans le polyedre 				*/
/************************************************************************/
int Draw_Int_Points (GdkDrawable * pixmap, Domain * D, GdkGC * couleur)
{
  int r;
  Value pt[MAXDIM];
  Polyhedron *pp, *pb;
  _dipD = pixmap;
  _dipC = couleur;
  _dipDomain = D;

  pb = DomainIntersection( D->visual->NPdomain, A_Conv, WS );
  r = 1;
  for (pp = pb; pp; pp = pp->next)
    r &= FORALL_P_do (pp, pt, &_dip);
  Domain_Free( pb );
  return (r);
}

/************************************************************************/
/* DrawLine : ligne entre 2 points dans le repere (reel) a 2 dimensions */
/************************************************************************/
void DLine (GdkDrawable * pixmap, Point p1, Point p2)
{
  int x1, y1, x2, y2;

  x1 = DOMAIN_BORD / 2 + (float) ((p1.x - MinX) / (MaxX - MinX) * DWIDTH);
  x2 = DOMAIN_BORD / 2 + (float) ((p2.x - MinX) / (MaxX - MinX) * DWIDTH);
  y1 =
    Height - DOMAIN_BORD / 2 -
    (float) ((p1.y - MinY) / (MaxY - MinY) * DHEIGHT);
  y2 =
    Height - DOMAIN_BORD / 2 -
    (float) ((p2.y - MinY) / (MaxY - MinY) * DHEIGHT);

  if (x1 == x2 && y1 == y2)
    {
      /* point isole */
      DPoint (pixmap, p1, dgGC);
    }
  else
    {
      gdk_draw_line (pixmap, dgGC, x1, y1, x2, y2);
    }
}

/*************************************************************************/
/* DPoint() : draw one point (in a 2-dim real basis)			 */
/*************************************************************************/
void DPoint (GdkDrawable * pixmap, Point p1, GdkGC * couleur)
{
  int x1, y1;

  if (Width < DOMAIN_BORD || Height < DOMAIN_BORD)
    return;

  x1 = DOMAIN_BORD / 2 + (float) ((p1.x - MinX) / (MaxX - MinX) * DWIDTH);
  y1 =
    Height - DOMAIN_BORD / 2 -
    (float) ((p1.y - MinY) / (MaxY - MinY) * DHEIGHT);


  gdk_draw_line (pixmap, couleur, x1 - 3, y1 - 2, x1 - 3, y1 + 2);
  gdk_draw_line (pixmap, couleur, x1 - 2, y1 - 3, x1 - 2, y1 + 3);
  gdk_draw_line (pixmap, couleur, x1 - 1, y1 - 3, x1 - 1, y1 + 3);
  gdk_draw_line (pixmap, couleur, x1, y1 - 3, x1, y1 + 3);
  gdk_draw_line (pixmap, couleur, x1 + 1, y1 - 3, x1 + 1, y1 + 3);
  gdk_draw_line (pixmap, couleur, x1 + 2, y1 - 3, x1 + 2, y1 + 3);
  gdk_draw_line (pixmap, couleur, x1 + 3, y1 - 2, x1 + 3, y1 + 2);

}

/************************************************************************/
/* projection d'un point de l'espace (dimension n) dans le plan reel */
/************************************************************************/
Point ProjectionPoint (coords, size)
     Value *coords;		/* dim size+1 le dernier=diviseur */
     int size;
{
  int i;
  Point p;

  if (size > MAXDIM)
    {
      fprintf (stderr,
	       "Error : dimension is too high.\nplease increase 'MAXDIM' and rebuild\n");
      exit (0);
    }
  p.x = p.y = 0.;
  for (i = 0; i < size; ++i)
    {
      p.x += (float) (coords[i] * repere.matrice[i][0] / coords[size]);
      p.y += (float) (coords[i] * repere.matrice[i][1] / coords[size]);
    }
  return (p);
}

/************************************************************************/
/* ProjectionPointEntier()						*/
/************************************************************************/
/* projection d'un point de l'espace entier (dimension n) dans le plan reel */
Point ProjectionPointEntier (coords, size)
     Value *coords;
     int size;
{
  int i;
  Point p;

  if (size > MAXDIM)
    {
      fprintf (stderr,
	       "Error : dimension is too high.\nplease increase 'MAXDIM' and rebuild\n");
      exit (0);
    }
  p.x = p.y = 0.;
  for (i = 0; i < size; ++i)
    {
      p.x += coords[i] * repere.matrice[i][0];
      p.y += coords[i] * repere.matrice[i][1];
    }
  return (p);
}

/************************************************************************/
/* Calc_Extr( ) : calcule les extremas de la figure dans le plan 2-reel */
/************************************************************************/
void Calc_Extr ()
{
  int i;
  Point pt;

  if (A_Conv->NbRays == 0)
    return;
  pt = ProjectionPoint (&A_Conv->Ray[0][1], A_Conv->Dimension);
  MaxX = MinX = pt.x;
  MaxY = MinY = pt.y;

  for (i = 1; i < A_Conv->NbRays; ++i)
    {
      pt = ProjectionPoint (&A_Conv->Ray[i][1], A_Conv->Dimension);
      if (MaxX < pt.x)
	MaxX = pt.x;
      if (MaxY < pt.y)
	MaxY = pt.y;
      if (MinX > pt.x)
	MinX = pt.x;
      if (MinY > pt.y)
	MinY = pt.y;
    }
  if (MaxX == MinX)
    {
      MaxX += 1.;
      MinX -= 1.;
    }
  if (MaxY == MinY)
    {
      MaxY += 1.;
      MinY -= 1.;
    }

}

/************************************************************************/
/* Draw_Polyhedre_Plat()						*/
/* Dessine un polyedre dont les points sont coplanaires 		*/
/* (s'il ne le sont pas, la routine dessine l'enveloppe			*/
/*  convexe de la projection dans le plan) 				*/
/************************************************************************/
void
Draw_Polyhedre_Plat (GdkDrawable * pixmap, Polyhedron * P,
		     GdkGC * couleur, int f)
{
  int npoints, i;
  Point pt[WS];			/* points dans le plan (projection) */

  npoints = P->NbRays;

  /* initialisation du tableau de points dans le plan */
#ifdef SPRINT
printf("Segment: ");
#endif
  for (i = 0; i < npoints; ++i)
  {
#ifdef SPRINT
int j;
#endif
    pt[i] = ProjectionPoint (&P->Ray[i][1], P->Dimension);
#ifdef SPRINT
printf("(");
for(j=0; j<P->Dimension+1 ; j++ )
printf("%3d,", P->Ray[i][j]);
printf("%3d)", P->Ray[i][j]);
#endif
  }
#ifdef SPRINT
printf("\n");
#endif
  Draw_Polygone (pixmap, pt, npoints, couleur, f);
}

/************************************************************************/
/* Contour_Faces_Polyedre()                                             */
/* Dessine les bords des faces (2D) d'un polyedre                       */
/************************************************************************/
static void Contour_Faces_Polyedre (GdkDrawable * pixmap, Polyhedron * P)
{
  Faces *Facets, *F;

  if (P->Dimension - P->NbEq <= 1)
    /* la dimension geometrique du polyedre est <= 2 */
    /* on dessine les contours */
    Draw_Polyhedre_Plat (pixmap, P, dgGC, 0);	/* contours */
  else
    {
      Facets = CalcFaces (P);
      for (F = Facets; F; F = F->next)
			Contour_Faces_Polyedre (pixmap, F->P);
      FreeFaces (Facets);
    }
}


/************************************************************************/
/* Draw_Domain()                                                        */
/************************************************************************/
void
Draw_Domain (GdkDrawable * pixmap, Polyhedron * P, GdkGC * couleur, int r)
{
  Polyhedron *pp;
#ifdef SPRINT
printf("P = ");
Polyhedron_Print( stdout, "%3d ", P );
#endif
  for (pp = P; pp; pp = pp->next)
    Draw_Polyedre (pixmap, pp, couleur, r);
}

/************************************************************************/
/* Draw_Polyedre()                                                      */
/************************************************************************/
void
Draw_Polyedre (GdkDrawable * pixmap, Polyhedron * P, GdkGC * couleur, int r)
{
  if (r)
    Draw_Polyhedre_Plat (pixmap, P, couleur, r);	/* remplissage */

  /* dessine le contour en fil de fer */
  Contour_Faces_Polyedre (pixmap, P);
}

/* Dessine un polyedre dont les faces ont etees precedemment calculees */
/* flag=1 first, -1 last, 0 toutes */

/************************************************************************/
/* Draw_Faces()								*/
/* int flag;	 1:first / -1:last / 0:all  				*/
/* int motif;	 remplissage 						*/
/************************************************************************/
void Draw_Faces (GdkDrawable * pixmap, Faces * fac, int flag, int motif)
{

	/*-- display of each face --*/
  for (; fac; fac = fac->next)
    {
      if (flag)
	if (flag * fac->Epaisseur <= 0)
	  continue;

      if (motif)
	{
	  /*XSetStipple( display, gc, bitmap0 );
	     XSetFillStyle( display, gc, FillStippled ); */
	}
		/*---- not used here but dgGC should be changed to other style*/
      if (flag == 1)
	Draw_Polyedre (pixmap, fac->P, dgGC, 1);
      else if (flag == -1)
	Draw_Polyedre (pixmap, fac->P, dgGC, 1);
      else
	Draw_Polyedre (pixmap, fac->P, dgGC, 0);

      /*XSetFillStyle( display, gc, FillSolid ); */
    }
}

/************************************************************************/
/* Draw_Polygone()							*/
/* Dessine un polygone dans le plan 2-reel 				*/
/* *pt 		: ptr sur un tableau de points dans le plan REEL 	*/
/* npoints	: nombre de points 					*/
/* mode_plein	: remplissage ou non 					*/
/************************************************************************/
void
Draw_Polygone (GdkDrawable * pixmap, Point * pt, int npoints,
	       GdkGC * couleur, int mode_plein)
{
  Point V, Vp;
  GdkPoint points[WS];

  float vecz;
  int p, nextp, ptmp;
  int i;
  int orig;

  if (npoints <= 1)
    return;

  if (npoints == 2)
    {
      DLine (pixmap, pt[0], pt[1]);
      return;
    }

  /* Affichage : il faut ordonner les points pour trouver
     l'enveloppe convexe (on a pour l'instant un ENSEMBLE
     de points, il faut une liste ordonnee !) */

  /*  premier point (pour fermer le polygone) : orig */
  /* choisit le plus haut a gauche */
  orig = 0;
  for (i = 1; i < npoints; ++i)
    {
      if (pt[i].y < pt[orig].y)
	orig = i;
      else if (pt[i].y == pt[orig].y && pt[i].x < pt[orig].x)
	orig = i;
    }

  p = orig;
  i = 0;

  points[0].x =
    DOMAIN_BORD / 2 + (float) ((pt[p].x - MinX) / (MaxX - MinX) * DWIDTH);
  points[0].y =
    Height - DOMAIN_BORD / 2 -
    (float) ((pt[p].y - MinY) / (MaxY - MinY) * DHEIGHT);
  do
    {
      ++i;

      /* recherche du point suivant p */
      /* nextp choisit arbitrairement au debut. */
      /* Vp est le vecteur de p a nextp */
      nextp = (p + 1) % npoints;
      Vp.x = pt[nextp].x - pt[p].x;
      Vp.y = pt[nextp].y - pt[p].y;

      /* recherche du meilleurs nextp */
      for (ptmp = 0; ptmp < npoints; ++ptmp)
	{
	  if (pt[ptmp].x == pt[p].x && pt[ptmp].y == pt[p].y)
	    continue;

	  V.x = pt[ptmp].x - pt[p].x;
	  V.y = pt[ptmp].y - pt[p].y;

	  /* produit vectoriel */
	  vecz = V.x * Vp.y - V.y * Vp.x;
	  /* le produit vectoriel teste le cote du point ptmp / droite (p,nextp) */
	  if (vecz <= 1e-10)
	    {
	      if (vecz >= -1e-10)	/* je considere que vecz = 0 */
		{
		  /* alors il y a 3 pts alignes : on prend le nouveau */
		  /* s'il est plus loin que l'autre */
		  if (Vp.x * Vp.x + Vp.y * Vp.y	/* dist. p nextp */
		      < V.x * V.x + V.y * V.y	/* dist. p ptmp */
		    )
		    {
		      nextp = ptmp;
		      Vp.x = V.x;
		      Vp.y = V.y;
		    }
		}
	      else
		{		/* cas classique : le nouveau point est a gauche */
		  /* de celui choisit precedemment */
		  nextp = ptmp;
		  Vp.x = V.x;
		  Vp.y = V.y;
		}
	    }
	}
      p = nextp;
      points[i].x =
	DOMAIN_BORD / 2 + (float) ((pt[p].x - MinX) / (MaxX - MinX) * DWIDTH);
      points[i].y =
	Height - DOMAIN_BORD / 2 -
	(float) ((pt[p].y - MinY) / (MaxY - MinY) * DHEIGHT);

    }
  while (i <= npoints		/* securite : impossible en theorie. */
	 && !(points[0].x == points[i].x && points[0].y == points[i].y));

  if (mode_plein)
    /* remplissage */
    /*XFillPolygon( pixmap,gc, points, i+1, Convex,
       CoordModeOrigin ) */ ;
  else
    {
      /* contour */
      /* in /usr/include/X11/X.h CoordModeOrigin == 0 */
      gdk_draw_lines (pixmap, dgGC, points, i + 1);
      /*XSetForeground( display, gc, xv_get(cms_domain, CMS_PIXEL, COL_NORM) ); */
    }

}
