/*
     COPYRIGHT
          Both this software and its documentation are
 
              Copyrighted 1997 by Vincent Loechner.
              GTK Code 1999 by Stephane Genaud.

          Permission is granted to copy, use, and distribute
          for any commercial or noncommercial purpose under the terms
          of the GNU General Public license, version 2, June 1991
          (see file : LICENSING).
*/

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <polylib/polylib64.h>

#include "visutypes.h"
#include "gtk_domain.h"
#include "gtk_windows.h"
#include "gtk_ddraw.h"
#include "gtk_repere.h"
#include "gtk_context.h"
#include "gtk_properties.h"
#include "domains.h"

/*--- global variables ----*/
Polyhedron *Contexte;
char *ContextName;
char *TmpDomainName;

GtkWidget *domain_frame;
GtkWidget *rep_frame;
GtkWidget *domain_canvas;
GtkWidget *rep_canvas;
GtkWidget *context_button;
GdkDrawable *rg;
GdkDrawable *dg;
GdkGC *rgGC;
GdkGC *dgGC;
GtkWidget **B_Tab, **L_Tab;
GtkWidget *clist;
/*GCond *cond_fin;*/
GMutex *fin=NULL;

/*---------------------------------------------------------------------------*/


/*
  Slection / dslection d'un point dans une liste.
*/
ListValuePoints *ListValuePoints_Select (Value * pt, ListValuePoints * list)
{
  int i;
  ListValuePoints *lnew, *lprev=NULL, *lcur;

  for( lcur=list; lcur ; lcur=lcur->next )
    {
		for( i=0 ; i<DimNP ; i++ )
		{
			if (value_ne (pt[i], lcur->point[i]))
				break;
		}
		if( i==DimNP )
		{
			/* galit -> dslection */
			if( lprev )
			{
				lprev->next = lcur->next;
				free( lcur );
				return( list );
			}
			else
			{
				lnew = lcur->next;
				free( lcur );
				return( lnew );
			}
		}
		lprev = lcur;
    }
  /* Insertion du point dans la liste */
  lnew = (ListValuePoints *) malloc (sizeof (ListValuePoints));
  memcpy (lnew->point, pt, DimNP * sizeof (Value));
  lnew->next = list;
  return( lnew );
}

/*
  Insertion d'un point dans une liste sauf si ce point est dj dans la liste.
*/
ListValuePoints *ListValuePoints_Insert (Value * pt, ListValuePoints * list)
{
  int i;
  ListValuePoints *lnew, *lcur;

  lnew = (ListValuePoints *) malloc (sizeof (ListValuePoints));
  memcpy (lnew->point, pt, DimNP * sizeof (Value));
  for( lcur=list; lcur ; lcur=lcur->next )
    {
		for( i=0 ; i<DimNP ; i++ )
		{
			if (value_ne (lnew->point[i], lcur->point[i]))
				break;
		}
		if( i==DimNP )
		{
			free (lnew);
			return list;
		}
    }
  /* Insertion du point dans la liste */
  lnew->next = list;
  return( lnew );
}

/*
  Affichage de tous les points slectionns d'une liste.
*/
void ListValuePoints_Write (ListValuePoints * list)
{
  ListValuePoints *lcur;
  int i;
  float x, y;
  char s[100];
  Point xypt;

  lcur = list;
  while (list)
    {
      sprintf (s, "(%lld", list->point[0]);
      for (i = 1; i < DimNP; ++i)
	sprintf (s, "%s,%lld", s, list->point[i]);
      strcat (s, ")");
      xypt = ProjectionPointEntier (list->point, DimNP);
      x = DOMAIN_BORD / 2 + (float) ((xypt.x - MinX)
				     / (MaxX - MinX) * DWIDTH);
      y = Height - DOMAIN_BORD / 2 - (float) ((xypt.y - MinY)
					      / (MaxY - MinY) * DHEIGHT);
      AffPoint (dg, list->point, bluePen);
      gdk_draw_string (dg, font, bluePen, x + 4, y, s);
      list = list->next;
    }
  return;
}

/*
   Mise--jour de la liste de points d'un domaine (lors de son affichage)
   par rapport aux autres points slectionns.
*/
ListValuePoints *ListValuePoints_Update (Domain * UpDomain)
{
	Domain *d;
	ListValuePoints *PtCur, *List;

	List = NULL;
	for( d = DomainList; d ; d=d->next )
	{
		if (d->visual && d->visual->Lpoints)
		{
			for( PtCur=d->visual->Lpoints; PtCur ; PtCur = PtCur->next )
				if (DansDomaine (UpDomain->visual->NPdomain, PtCur->point))
					List = ListValuePoints_Insert (PtCur->point, List);
		}
	}
	return List;
}

/*
  Libre l'espace mmoire occup par la ListePoints  
*/
void ListValuePoints_Free (ListValuePoints * list)
{
  ListValuePoints *lcur, *lnext;
  lcur = list;
  while (lcur != NULL)
    {
      lnext = lcur->next;
      free (lcur);
      lcur = lnext;
    }
  return;
}

/*
  Libre l'espace mmoire occup par le VisualDomain 
*/
void VisualDomain_Free (VisualDomain * visual)
{
  if (visual == NULL)
    return;
  if (visual->NPdomain)
    Domain_Free (visual->NPdomain);
  if (visual->Lpoints)
    ListValuePoints_Free (visual->Lpoints);
  free (visual);
  visual = NULL;
  return;
}


/**********************************************************/
/*    Initialisation de la fentre de visualisation:      */
/*  les variables 'DimNP' et 'TmpDomainName' doivent tre */
/* initialises avant l'appel  'init_visu ()'.           */
/**********************************************************/

void init_visu ()
{
  gboolean test, initcolors;
  Domain *domain_cur;
  int i;

  /* Teste la validit de la nouvelle dimension (aprs instanciation) */
  if (DimNP <= 0)
    {
      /* La dimension des domaines instancis doit tre positive */
      Warn ("Bad initialisation of 'init_visu': DimNP <= 0 ");
      return;
    }
  if (DimNP > MAXDIM)
    {
      /* La dimension des domaines instancis doit tre infrieure  MAXDIM */
      Warn ("Bad initialisation of 'init_visu': DimNP > MAXDIM ");
      printf ("Now MAXDIM = %d. ", MAXDIM);
      Warn
	("If you want you can rebuild after increase MAXDIM in the file 'visutypes.h'");
      return;
    }

  if (Contexte)
    Domain_Free (Contexte);

  /* Recherche du contexte dans la liste des domaines */
  G_LOCK (verrou_domains);
  domain_cur = DomainList;
  while (domain_cur != NULL)
    {
      if (strcmp (domain_cur->name, TmpDomainName) == 0)
		{
		  Contexte = Domain_Copy (domain_cur->Pdomain);
		  ContextName = strdup (TmpDomainName);
		  break;
		}
      domain_cur = domain_cur->next;
    }
  G_UNLOCK (verrou_domains);
  if (domain_cur == NULL)
    {
      Warn ("The domain selected as context is not defined!");
      return;
    }

  /* Mise--jour du nombre de paramtres des domaines  visualiser */
  if (emptyQ (Contexte))
    {
      /* Il n'y a pas de contexte donc NbParam = 0 */
      NbParam = 0;
    }
  else
    NbParam = Contexte->Dimension;

  /* Initialisation des paramtres */
  if( NbParam)
  {
    if (ValidParam)
      free (ValidParam);
    ValidParam = (int *) malloc (NbParam * sizeof (int));
    memset (ValidParam, 0, NbParam * sizeof (int));
    if (ValeurParam)
      free (ValeurParam);
    ValeurParam = (Value *) malloc (NbParam * sizeof (Value));
  }

  /* Cration de la fentre du repre */
  if (GTK_IS_WIDGET (rep_frame))
    {
      gtk_widget_destroy (rep_frame);
      rep_frame = NULL;
    }
  rep_frame = create_rep_frame ();
  rep_init ();

  /* Mettre  jour les widgets des paramtres en fonction du contexte */
  if (GTK_IS_WIDGET (ContextWin))
    {
      gtk_widget_destroy (GTK_WIDGET (ContextWin));
      ContextWin = NULL;
    }
  /* Ne construire la fentre 'Context' que si elle est ncessaire */
  if (NbParam > 0)
    context_window_new ();

  if (!GTK_IS_WIDGET (domain_frame))
    {
      /* La fentre n'est ni cre ni affiche => c'est la 1re initialisation */
      initcolors = TRUE;

      /* Cration de la fentre des proprits des domaines */
      DomainsProperties ();

      /* Cration de la fentre de visualisation */
      domain_frame = create_domain_frame ();

    }
  else
    {
      /*     La fentre de visualisation est dj cre mais soit elle n'est */
      /* plus affiche, soit le contexte et/ou la dimension (aprs les avoir */
      /* instancis) des polydres  afficher ont/a chang */
      initcolors = FALSE;

      /* Fermer le slecteur de couleurs s'il est actif */
      if (GTK_IS_WIDGET (ColorDlg))
	{
	  gtk_widget_destroy (GTK_WIDGET (ColorDlg));
	  ColorDlg = NULL;
	}

      /* Rtablir le toggle_button 'context_button' */
      if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (context_button)))
	test = context_window_exit (NULL);

      /* Rtablir le toggle_button 'view_button' */
      if (!gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (view_button)))
	test = repere_exit (NULL);

      /* Mise--jour de la liste graphique */
      G_LOCK (verrou_domains);
      gtk_clist_freeze (GTK_CLIST (clist));
      for( domain_cur = DomainList; domain_cur ; domain_cur = domain_cur->next)
	{
		  /* Vider la liste des domaines affichs, i.e. champ visual <- NULL */
		  i = gtk_clist_find_row_from_data (GTK_CLIST (clist),
					   	 (gpointer) domain_cur);
		  if (i != -1)
	   	 {
	      	/* Masquer les domaines affichs */
	      	if (domain_cur->visual != NULL)
					gtk_clist_select_row (GTK_CLIST (clist), i, 1);

	      	/* Retirer le domaine de la liste s'il n'est plus affichable */
	      	if ((domain_cur->Pdomain->Dimension - NbParam) != DimNP)
					graphic_list_delete (domain_cur);
	   	 }

		  /* Sinon: des domaines ne sont pas dans la liste graphique
	   	  car ils n'ont pas la dimension adquate. */
		  else
	   	 /* Ne lister que les domaines affichables... */
	   	 graphic_list_update (domain_cur);
	}
      gtk_clist_thaw (GTK_CLIST (clist));
      G_UNLOCK (verrou_domains);

      /* Effacer le contenu de la fentre de visualisation */
      domain_redraw (dg, NULL);
    }

  /* Affichage de la fentre de visualisation */
  gtk_widget_show_all (GTK_WIDGET (domain_frame));
  if (NbParam == 0)
    gtk_widget_hide (GTK_WIDGET (context_button));
  if (initcolors == TRUE)
    init_Colors ();
  return;
}


gpointer GtkMainFunc (gpointer arg)
{
  gdk_threads_enter ();
  gtk_main ();
  gdk_threads_leave ();
  return( NULL );
//  g_thread_exit (NULL);
}


int main (int argc, char **argv)
{
  GThread *thread;GError *g_err=NULL;
  int y;

  domain_frame = NULL;
  A_Conv = NULL;
  A_Union = NULL;
  NbRows = 0;

  /* Initialisation des threads GTK */
  g_thread_init (NULL);
  gdk_threads_init ();

  /* Initialisation des bibliotheques GTK */
  gtk_init (&argc, &argv);

  /* Cration du thread GtkMain */
//  pthread_create (&thread, NULL, GtkMainFunc, NULL);
   thread = g_thread_create( GtkMainFunc, NULL, 1, &g_err );

  fprintf(stdout, "<1> ");

  /* Boucle principale */
  y = yyparse (NULL);

  printf( "End.\n");
  /* end of yyparsing */
  gdk_threads_enter ();
  if (y != -1 && domain_frame )
  {
  		if(GTK_WIDGET_VISIBLE (GTK_WIDGET (domain_frame)))
		{
			/* attend */
			printf( "Waiting for user to leave graphical interface.\n");
			gdk_threads_leave ();

			g_thread_join(thread);
		}
	  else
		{
			gdk_threads_leave ();
			g_thread_join(thread);
		}
	}
  else
	{
		gtk_main_quit();
		gdk_threads_leave ();
		g_thread_join(thread);
	}

  return (0);
}
