/* gtk_domain.c
     COPYRIGHT
          Both this software and its documentation are
 
              Copyrighted 1997 by Vincent Loechner.
	      GTK Code 1999 by Stephane Genaud.

          Permission is granted to copy, use, and distribute
          for any commercial or noncommercial purpose under the terms
          of the GNU General Public license, version 2, June 1991
          (see file : LICENSING).
*/

#include <gtk/gtk.h>
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#include <polylib/polylib64.h>

#include "visutypes.h"
#include "domains.h"
#include "gtk_domain.h"
#include "gtk_repere.h"
#include "gtk_ddraw.h"
#include "gtk_windows.h"
#include "gtk_properties.h"
#include "gtk_context.h"

Polyhedron *A_Conv, *A_Union, *U_NPDomains, *U_IntPDomains;
Polyhedron *Contexte, *PParam;
int DimNP = 0;
int NbParam = 0;
int *ValidParam;
Value *ValeurParam;
gboolean ContextOK = FALSE;

int is_pt_selected = 0;
float MaxX, MaxY, MinX, MinY;
int Width, Height;

static Point cxy;
static double dist;
Value pt_selected[MAXDIM];
int intpoints = 1;


/************************************************************************/
/* domain_redraw() : draw domains in the pixmap 	                */
/************************************************************************/
void domain_redraw (GdkDrawable * pixmap, Domain * domain)
{
	Domain *d;
	GdkRectangle update_rect;

	/*--- clear domain window ----*/
	if (whitePen)
	{	/*-- whitePen may have not been created yet --*/
		gdk_draw_rectangle (pixmap, whitePen, TRUE, 0, 0,
		domain_canvas->allocation.width,
		domain_canvas->allocation.height);
	}
	if (A_Conv && U_NPDomains && A_Conv->NbRays != 0)
	{
		/* calcul des extremas pour le centrage de la figure */
		Calc_Extr ();
		/*************************/
		/* Redisplay the domains */
		/*************************/
		for ( d = DomainList; d ; d=d->next )
		{
			if (d->visual != NULL)
			{
				/* Affichage du domaine */
				gdk_gc_set_foreground (dgGC, d->color);
				Draw_Domain (pixmap, d->visual->NPdomain, dgGC, 0);
				if (d->visual->intpoints)
				{
					/* Affichage de tous les points entiers du domaine */
					if (Draw_Int_Points (pixmap, d,dgGC))
						ListValuePoints_Write (d->visual->Lpoints);			
				}
			}
		}
	}

	/* call an expose event */
	update_rect.x = 0;
	update_rect.y = 0;
	update_rect.width = domain_canvas->allocation.width;
	update_rect.height = domain_canvas->allocation.height;
	gtk_widget_draw (domain_canvas, &update_rect);
	gtk_widget_queue_draw_area (GTK_WIDGET (domain_canvas), 0, 0,
			      domain_canvas->allocation.width,
			      domain_canvas->allocation.height);
}

/************************************************************************/
/* Warn()								*/
/************************************************************************/
void Warn (char *s)
{
  printf ("%s\n", s);
}


int isanumber (char *s)
{
  if (*s == '+' || *s == '-')
    ++s;
  if (!*s)
    return (0);
  if (strspn (s, "1234567890") != strlen (s))
    return (0);
  else
    return (1);

}

/************************************************************************/
/* chg_param () : one of the entries has changed			*/
/************************************************************************/
void chg_param (GtkWidget * widget, GtkWidget * entry)
{
  int n, i;
  char *new_param;
  Domain *d;
  
	/*--- look for the parameter that has changed ---*/
  for (n = 0; n < NbParam; ++n)
    {
      /* si c'est pas celui la on continue. */
      if (B_Tab[n] == widget)
	break;
    }
  if (n == NbParam)
    {
      fprintf (stderr, "Internal error: Can't find parameter panel_item.\n");
      return;
    }
  is_pt_selected = 0;
  new_param = (char *) gtk_entry_get_text (GTK_ENTRY (entry));
  if (isanumber (new_param))
    {
      ValidParam[n] = 1;
      value_read (ValeurParam[n],
		  (char *) gtk_entry_get_text (GTK_ENTRY (entry)));
      for (i = 0; i < NbParam; ++i)
	if (!ValidParam[i])
	  break;
      if (i == NbParam)
		{
		  /************ LES PARAMS SONT OK ************/
		  if (Contexte == NULL)
	   	 { /* Paranoa : a n'arrive jamais normalement... */
	      	Warn ("Problem: Contexte == NULL");
	      	return;
	   	 }

		  /* verifier bon contexte */
		  if (!DansDomaine (Contexte, ValeurParam))
	   	 {
				ContextOK = FALSE;
				printf ("Bad parameters for this context!\n");
				mask_all_domains (GTK_CLIST (clist));

				clear_A_domains();
	   	 }
		  else
	   	 {
	      	ContextOK = TRUE;
			  /* Il y a des domaines  afficher */
			  /* M--j des domaines instancis */
			  for( d = DomainList; d ; d=d->next )
		   	  if (d->visual)
		      	  Affich_P_domains (d, -1);
	   	 }
		}
      else
		{
			ContextOK = FALSE;
			clear_A_domains();
		}
    }
  else
    {
		ContextOK = TRUE;
		if (strcmp (new_param, "\0") != 0)
		{
	  /* Masquer tous les domaines */
//          mask_all_domains (GTK_CLIST (clist));
//	  Warn ("Parameter must be integer!");
			ValidParam[n] = 0;
			ContextOK = FALSE;
			clear_A_domains();
		}
		else
		{
			/*--- Il y a des domaines  afficher ---*/
			clear_A_domains();
			compute_A_domains ();

			calc_rep_extr ();
		}
    }
  domain_redraw (dg, NULL);
  return;
}

/************************************************************************/
/* CalcFaces() d'un polyedre (pas d'une union)                          */
/************************************************************************/
Faces *CalcFaces (Polyhedron * P)
{
  int i;
  Faces *f, *tmp;
  Matrix *contraintes;

  if (P->Dimension < 2)
    return (NULL);

  /* allocation dynamique des faces (Faces *) du polyedre */
  f = NULL;
  contraintes = Polyhedron2Constraints (P);
  for (i = 0; i < P->NbConstraints; ++i)
    {
      /* intersection entre ce plan et le polyedre entier */
      if (contraintes->p[i][0] != 0)
	{
	  tmp = f;
	  f = (Faces *) malloc (sizeof (Faces));
	  f->next = tmp;
			/*--- makes an equality from inequality---*/
	  contraintes->p[i][0] = 0;
	  f->P = Constraints2Polyhedron (contraintes, WS);

	  /* contraintes est modifie par C2P !!! */
	  memcpy (&contraintes->p[0][0], &P->Constraint[0][0],
		  sizeof (Value) * (P->Dimension + 2) * P->NbConstraints);
	}
    }
  Matrix_Free (contraintes);
  return (f);
}

void FreeFaces (Faces * F)
{
  Faces *fs;
  while (F)
    {
      fs = F->next;
      Polyhedron_Free (F->P);
      free (F);
      F = fs;
    }
}

/****************************************************/
/* Routines pour la selection d'un point du domaine */
/****************************************************/
static int _find_near_pt (Value * pt)
{
  Point xypt;
  double d;

  xypt = ProjectionPointEntier (pt, DimNP);
/*  d = sqrt ((xypt.x - cxy.x) * (xypt.x - cxy.x) +
	    (xypt.y - cxy.y) * (xypt.y - cxy.y)); */
  d =  ((xypt.x - cxy.x) * (xypt.x - cxy.x) +
	    (xypt.y - cxy.y) * (xypt.y - cxy.y));
  if ( (dist < 0. || d < dist) && d<200. )
    {
      dist = d;
		/*--- a closest one has been found -----*/
      memcpy (pt_selected, pt, DimNP * sizeof (Value));
    }
  return 1;
}

/************************************************************************/
/* domain_event() : called after an event_button_pressed in the domain	*/
/* window. Computes which point must be highligthed.			*/
/************************************************************************/
void domain_event (int cx, int cy)
{
  Polyhedron *pp;
  Value pt[MAXDIM];
  Domain *Dcur;
  
  /* cherche le point le plus proche du clic souris */
  cxy.x = (float) ((cx - DOMAIN_BORD / 2) * (MaxX - MinX)) / DWIDTH + MinX;
  cxy.y = (float) ((-cy + Height - DOMAIN_BORD / 2) * (MaxY - MinY))
    / DHEIGHT + MinY;
  dist = -1.;

/*  if (!U_IntPDomains)
*/
     union_intpoints_domains ();
  for (pp = U_IntPDomains; pp; pp = pp->next)
  {
    /* FORALL_P_do must be called with a convex polyhedron */
    Polyhedron *tnext;
    tnext = pp->next;
    pp->next = NULL;
    FORALL_P_do (pp, pt, &_find_near_pt);
    pp->next = tnext;
  }
  if (dist >= 0.)  
    {
      G_LOCK (verrou_domains);
      Dcur = DomainList;
      while (Dcur)
        {
	 if (Dcur->visual && 
	     DansDomaine (Dcur->visual->NPdomain, pt_selected))
            Dcur->visual->Lpoints = 
	           ListValuePoints_Select (pt_selected, Dcur->visual->Lpoints);
	 Dcur = Dcur->next;
	 }
      G_UNLOCK (verrou_domains);
      domain_redraw (dg, NULL);
    }

}
