/*
 * This file is part of the "nlr" software.
 *
 * Copyright (C) 2009-2021 Alain Ketterlin, Philippe Clauss and
 * Université de Strasbourg
 *
 * Licensing information can be found in the LICENSE file that comes
 * with the source distribution.
 *
 * Contact:
 * - Alain Ketterlin (alain@unistra.fr)
 * - Philippe Clauss (clauss@icps.u-strasbg.fr)
 */

#ifndef _UTILS_H_INCLUDED
#define _UTILS_H_INCLUDED

#include <stdlib.h>
#include <stdio.h>


#define fatal(...) \
    do {                                             \
        fprintf(stderr,__VA_ARGS__);                 \
        fputs("\n",stderr);                          \
        abort();                                     \
    } while (0)

/* This macro ensures that initializations can be compiled in C and C++ */
#ifdef __cplusplus
#define INITFIELD(name,val) val
#else
#define INITFIELD(name,val) . name = val
#endif


static inline void * xmalloc(size_t size)
{
    void * value = malloc(size);
    if (value == NULL)
        fatal("malloc failed\n");
    return value;
}
static inline void * xrealloc(void * ptr, size_t size)
{
    register void * value = realloc(ptr,size);
    if (value == NULL)
        fatal("realloc failed\n");
    return value;
}
static inline void xfree(void * ptr)
{
    free(ptr);
}

const char * mystrdup(const char * s);

void sigs_setup();
int sigs_usr1();
int sigs_usr2();


#endif
