/*
 * This file is part of the "nlr" software.
 *
 * Copyright (C) 2009-2021 Alain Ketterlin, Philippe Clauss and
 * Université de Strasbourg
 *
 * Licensing information can be found in the LICENSE file that comes
 * with the source distribution.
 *
 * Contact:
 * - Alain Ketterlin (alain@unistra.fr)
 * - Philippe Clauss (clauss@icps.u-strasbg.fr)
 */

#include <stdarg.h>
#include <signal.h>
#include <string.h>
#include "utils.h"

const char * mystrdup(const char * s)
{
    char * n = xmalloc(strlen(s)+1);
    strcpy(n,s);
    return n;
}


static volatile int sigs_usr1_caught = 0;
static volatile int sigs_usr2_caught = 0;

void sigs_handler(int s)
{
    if ( s == SIGUSR1 )
        sigs_usr1_caught = 1;
    else if ( s == SIGUSR2 )
        sigs_usr2_caught = 1;
    signal(s,sigs_handler);
}

void sigs_setup()
{
    signal(SIGUSR1,sigs_handler);
    signal(SIGUSR2,sigs_handler);
}

int sigs_usr1()
{
    int r = sigs_usr1_caught;
    sigs_usr1_caught = 0;
    return r;
}
int sigs_usr2()
{
    int r = sigs_usr2_caught;
    sigs_usr2_caught = 0;
    return r;
}
