/*
 * This file is part of the "nlr" software.
 *
 * Copyright (C) 2009-2021 Alain Ketterlin, Philippe Clauss and
 * Université de Strasbourg
 *
 * Licensing information can be found in the LICENSE file that comes
 * with the source distribution.
 *
 * Contact:
 * - Alain Ketterlin (alain@unistra.fr)
 * - Philippe Clauss (clauss@icps.u-strasbg.fr)
 */

#ifndef _ARGS_H_INCLUDED
#define _ARGS_H_INCLUDED

#include <stdio.h>
#include "termes.h"

typedef term_t * (*read_term_t)(model_t,model_t,FILE *);
typedef void (*write_term_t)(const term_t *, model_t, model_t,
                             FILE *, const dumpfmt_t *);

typedef struct s_param {
    struct {
        model_t values;
        model_t bounds;
        read_term_t r_term;
        write_term_t w_term;
        unsigned int maxstack;
        unsigned int flushstack;
    } general;
    struct {
        unsigned int k;
        func_unif3_t unif3_bound;
        func_unif3_t unif3_value;
    } terms;
    struct {
        unsigned int p;
        unsigned int d;
        unsigned int w;
    } prediction;
    struct {
        unsigned int k;
        func_inif3_t inif3_bound;
        bool irreg_bound;
        func_inif3_t inif3_value;
        bool irreg_value;
    } irregular;
    struct {
        unsigned int verbosity;
        unsigned int flags;
        unsigned int every;
        unsigned int size;
    } debug;
    dumpfmt_t dump;
} param_t;

#define PARAM_DUMP(p,n) ( (p)->debug.flags && (p)->debug.every \
                          && ( (n) % (p)->debug.every == 0 ) )


/* FIXME: INITFIELD doesn't work for nested initialization */
#ifdef __cplusplus
#define PARAM_DEFAULTS { \
        {                                       \
            INITFIELD(values,M_POLY),           \
                INITFIELD(bounds,M_POLY),       \
                INITFIELD(r_term,term_text),    \
                INITFIELD(w_term,term_dump),    \
                INITFIELD(maxstack,100000),     \
                INITFIELD(flushstack,10000)     \
                },                              \
        {                                       \
            INITFIELD(k,1),                     \
                INITFIELD(unif3_bound,func_unif3_poly), \
                INITFIELD(unif3_value,func_unif3_poly)  \
                },                                      \
        {                                               \
            INITFIELD(p,0),                             \
                INITFIELD(d,0),                         \
                INITFIELD(w,0)                          \
                },                                      \
        {                                               \
            INITFIELD(k,0),                             \
                INITFIELD(inif3_bound,func_inif3_poly), \
                INITFIELD(irreg_bound,true)             \
                INITFIELD(inif3_value,func_inif3_poly), \
                INITFIELD(irreg_value,true)             \
                },                                      \
        {                                               \
            INITFIELD(verbosity,0x0),                   \
                INITFIELD(flags,0x1),                   \
                INITFIELD(every,-1),                    \
                INITFIELD(size,5)                       \
                },                                      \
            INITFIELD(dump,DUMPFMT_DEFAULTS)            \
}
#else
#define PARAM_DEFAULTS { \
        .general = {                            \
            INITFIELD(values,M_POLY),           \
                INITFIELD(bounds,M_POLY),       \
                INITFIELD(r_term,term_text),    \
                INITFIELD(w_term,term_dump),    \
                INITFIELD(maxstack,100000),     \
                INITFIELD(flushstack,10000)     \
                },                            \
    .terms = { \
        INITFIELD(k,1),                       \
        INITFIELD(unif3_bound,func_unif3_poly), \
        INITFIELD(unif3_value,func_unif3_poly)  \
     }, \
     .prediction = {                        \
        INITFIELD(p,0), \
        INITFIELD(d,0), \
        INITFIELD(w,0)  \
     }, \
     .irregular = {                         \
        INITFIELD(k,0), \
        INITFIELD(inif3_bound,func_inif3_poly), \
        INITFIELD(irreg_bound,true), \
        INITFIELD(inif3_value,func_inif3_poly), \
        INITFIELD(irreg_value,true) \
      },                                  \
    .debug = { \
        INITFIELD(verbosity,0x0),               \
        INITFIELD(flags,0x1),                   \
        INITFIELD(every,-1),                    \
        INITFIELD(size,5)                       \
     }, \
         INITFIELD(dump,DUMPFMT_DEFAULTS)       \
}
#endif

void
scan_args(int argc, char ** argv, param_t * p);



#endif
