/*
 * COMP 203:  C + OpenMP example program -- SINGLE PARALLEL REGION
 *
 */
#include <stdio.h>
#include <math.h>
#include <time.h>
#include <omp.h>
#define N_MAX 10000000 /* 10,000,000 */

double a[N_MAX],b[N_MAX];
double elapsed_time(const timespec_t t2, const timespec_t t1);

main (int argc, char *argv[])
{
  timespec_t t1,t2;
  double td, target_work;
  int i, t, max_threads, num_threads, niter, n;

  /*
   * set iterations to keep parallel running time approximately constant
   * independent of problem size and number of threads
   */
  n = N_MAX;
  if (argc > 1) {
    n = atoi(argv[1]);
  }
  n = ( n > 0 && n <= N_MAX) ? n : N_MAX;
  max_threads = omp_get_max_threads();  
  target_work = 2.0 * N_MAX * max_threads;
  niter = (int) ceil( target_work / n );
  niter = 2 * ((niter + 1) / 2);

  /*
   * initialize arrays
   */
  printf("Init:");
  fflush(stdout);

#pragma omp parallel private(i,t) 
  {
#pragma omp for schedule(runtime)
    for (i = 0; i < n; i++){
      a[i] = 0.0;
      b[i] = 0.0;
    }

#pragma omp master
    {
      a[0] = 1.0;
      b[0] = 1.0;
      num_threads = omp_get_num_threads();  /* actual num threads */
      printf("\b\b\b\b\bTest:  n = %8d, p = %2d, niter = %8d, ...",
	 n, num_threads, niter);
      fflush(stdout);
      clock_gettime(CLOCK_SGI_CYCLE,&t1);
    }

#pragma omp barrier

    for (t = 0; t < niter; t = t + 2){

#pragma omp for schedule(runtime)
      for (i = 1; i < n-1; i++)
	b[i] = (a[i-1] + a[i] + a[i+1]) / 3.0;

#pragma omp for schedule(runtime)
      for (i = 1; i < n-1; i++)
	a[i] = (b[i-1] + b[i] + b[i+1]) / 3.0;
    }

#pragma omp master
    {
      clock_gettime(CLOCK_SGI_CYCLE,&t2);
      td = elapsed_time(t2,t1);
      printf("\b\b\btime per elt = %6.1f ns\n", (td * 1E9) / (niter*n));
    }
  } /* end parallel */
}


/*
 * elapsed time in seconds for POSIX-compliant clocks
 */
double elapsed_time(const timespec_t t2, const timespec_t t1)
{
   return   (((double)t2.tv_sec) + ((double)t2.tv_nsec / 1e9)) 
          - (((double)t1.tv_sec) + ((double)t1.tv_nsec / 1e9));
}

