#include <omp.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>

typedef struct _tcs_TIME
{
  struct timeval startzeit;
  struct timeval endzeit;
  struct timezone zeitzone;
} tcs_TIME;

tcs_TIME* tcs_START_TIMER()
{
  tcs_TIME* zeit = (tcs_TIME*) malloc(sizeof(tcs_TIME));
  if( zeit!= NULL)
    gettimeofday(&(zeit->startzeit),&(zeit->zeitzone));
  return zeit;
}

double tcs_STOP_TIMER(tcs_TIME* zeit)
{
  double zeitdifferenz=0.0;
  if(zeit!=NULL)
    {
      gettimeofday(&(zeit->endzeit),&(zeit->zeitzone));
      zeitdifferenz = (double)(zeit->endzeit.tv_sec)+(double)(zeit->endzeit.tv_usec)/1000000.0-((double)(zeit->startzeit.tv_sec)+(double)(zeit->startzeit.tv_usec)/1000000.0); 
      free(zeit);
    }
  else
    fprintf(stderr,"tcs_STOP_TIMER: there was no time difference.\n");
  
  return zeitdifferenz;
}

double tcs_READ_TIMER(tcs_TIME* zeit)
{
  double zeitdifferenz=0.0;
  if(zeit!=NULL)
    {
      gettimeofday(&(zeit->endzeit),&(zeit->zeitzone));
      zeitdifferenz = (double)(zeit->endzeit.tv_sec)+(double)(zeit->endzeit.tv_usec)/1000000.0-((double)(zeit->startzeit.tv_sec)+(double)(zeit->startzeit.tv_usec)/1000000.0); 
    }
  else
    fprintf(stderr,"tcs_READ_TIMER: there was no time difference.\n");
  
  return zeitdifferenz;
}


void main(int argc,char *argv[])
{
  long int i,j;	
  long int sum=0;
  int chunk_size;
  double zeitdifferenz;
  tcs_TIME* zeit;
  
omp_set_num_threads(72);

if (argc!=2) {   printf("Don't forget about number of iterations\n"); exit(1);  }
j = atol(argv[1]);;

chunk_size=1;
zeit = tcs_START_TIMER(); 
#pragma omp parallel shared(j,sum)
{
#pragma omp for schedule(dynamic,chunk_size)
    for(i=0;i<j;i++)
      {
     sum++;	
      }
} //end of #parallel
zeitdifferenz= tcs_STOP_TIMER(zeit);
//printf("<tr><td>None</td><td>%ld</td><td>%ld</td><td>%d</td><td>%lf</td></tr>\n",sum,j,chunk_size,zeitdifferenz);
printf("None: SUM = %ld, Iter = %ld, chunk size = %d, time = %lf \n",sum,j,chunk_size,zeitdifferenz);
sum=0;

chunk_size=2;
zeit = tcs_START_TIMER(); 
#pragma omp parallel shared(j,sum)
{
#pragma omp for schedule(dynamic,chunk_size)
    for(i=0;i<j;i++)
      {
     sum++;	
      }
} //end of #parallel
zeitdifferenz= tcs_STOP_TIMER(zeit);
printf("None: SUM = %ld, Iter = %ld, chunk size = %d, time = %lf \n",sum,j,chunk_size,zeitdifferenz);
sum=0;

chunk_size=3;
zeit = tcs_START_TIMER(); 
#pragma omp parallel shared(j,sum)
{
#pragma omp for schedule(dynamic,chunk_size)
    for(i=0;i<j;i++)
      {
     sum++;	
      }
} //end of #parallel
zeitdifferenz= tcs_STOP_TIMER(zeit);
printf("None: SUM = %ld, Iter = %ld, chunk size = %d, time = %lf \n",sum,j,chunk_size,zeitdifferenz);
sum=0;

chunk_size=1;
zeit = tcs_START_TIMER(); 
#pragma omp parallel shared(j,sum)
{
#pragma omp for schedule(dynamic,chunk_size)
    for(i=0;i<j;i++)
      {
#pragma omp atomic
     sum++;	
      }
} //end of #parallel
zeitdifferenz= tcs_STOP_TIMER(zeit);
printf("Atomic: SUM = %ld, Iter = %ld, chunk size = %d, time = %lf \n",sum,j,chunk_size,zeitdifferenz);
sum=0;

chunk_size=2;
zeit = tcs_START_TIMER(); 
#pragma omp parallel shared(j,sum)
{
#pragma omp for schedule(dynamic,chunk_size)
    for(i=0;i<j;i++)
      {
#pragma omp atomic
     sum++;	
      }
} //end of #parallel
zeitdifferenz= tcs_STOP_TIMER(zeit);
printf("Atomic: SUM = %ld, Iter = %ld, chunk size = %d, time = %lf \n",sum,j,chunk_size,zeitdifferenz);
sum=0;

chunk_size=3;
zeit = tcs_START_TIMER(); 
#pragma omp parallel shared(j,sum)
{
#pragma omp for schedule(dynamic,chunk_size)
    for(i=0;i<j;i++)
      {
#pragma omp atomic
     sum++;	
      }
} //end of #parallel
zeitdifferenz= tcs_STOP_TIMER(zeit);
printf("Atomic: SUM = %ld, Iter = %ld, chunk size = %d, time = %lf \n",sum,j,chunk_size,zeitdifferenz);
sum=0;


chunk_size=1;
zeit = tcs_START_TIMER(); 
#pragma omp parallel shared(j,sum)
{
#pragma omp for schedule(dynamic,chunk_size)
    for(i=0;i<j;i++)
      {
#pragma omp critical
     sum++;	
      }
} //end of #parallel
zeitdifferenz= tcs_STOP_TIMER(zeit);
printf("Critical: SUM = %ld, Iter = %ld, chunk size = %d, time = %lf \n",sum,j,chunk_size,zeitdifferenz);
sum=0;

chunk_size=2;
zeit = tcs_START_TIMER(); 
#pragma omp parallel shared(j,sum)
{
#pragma omp for schedule(dynamic,chunk_size)
    for(i=0;i<j;i++)
      {
#pragma omp critical
     sum++;	
      }
} //end of #parallel
zeitdifferenz= tcs_STOP_TIMER(zeit);
printf("Critical: SUM = %ld, Iter = %ld, chunk size = %d, time = %lf \n",sum,j,chunk_size,zeitdifferenz);
sum=0;

chunk_size=3;
zeit = tcs_START_TIMER(); 
#pragma omp parallel shared(j,sum)
{
#pragma omp for schedule(dynamic,chunk_size)
    for(i=0;i<j;i++)
      {
#pragma omp critical
     sum++;	
      }
} //end of #parallel
zeitdifferenz= tcs_STOP_TIMER(zeit);
printf("Critical: SUM = %ld, Iter = %ld, chunk size = %d, time = %lf \n",sum,j,chunk_size,zeitdifferenz);

printf("\n");

  
}
