#include <stdio.h>
#include <time.h>

#define f(A) (4.0/(1.0+A*A))

const int n = 10000000;

int main(int argc, char** argv)
{
  int i;
  double w,x,sum,pi,sum0;
  clock_t t;

  t=clock();
/* calculate the interval size */
  w=1.0/n;
  sum=0.0;
#pragma omp parallel private (x,sum0) shared(w,sum)
{
  sum0=sum;
#pragma omp for
  for (i=1;i<=n;i++)
  {
    x=w*((double)i-0.5);
    sum0=sum0+f(x);
  }
#pragma omp critical
{
    sum=sum+sum0;
}
}
  pi=w*sum;

  t=clock();
  printf( "computed pi = %24.16g\n", pi );
  printf( "CPU time = %12.4g sec\n", t/1000000.0 );
  return 0;
}
