program compute_pi

! times using cpu_time
real t0,t1

integer i
integer, parameter        :: n=10000000
real(kind=8) w,x,sum,pi,f,a

! function to integrate
f(a)=4.0_8/(1.0_8+a*a)

call cpu_time(t0)

! calculate the interval size
w=1.0_8/n
sum=0.0_8

!$OMP PARALLEL PRIVATE(x), SHARED(w,sum)
!$OMP DO
do i=1,n
   x=w*(i-0.5_8)
   sum=sum+f(x)
enddo
!$OMP END DO
!$OMP END PARALLEL
pi=w*sum

call cpu_time(t1)

write (*,'(/,a,1pg24.16)')   'computed pi = ', pi
write (*,'(/,a,1pg12.4)')    'cpu_time:     ', t1-t0
stop
end program compute_pi
