#include <stdio.h>
#include <time.h>

#define f(A) (4.0/(1.0+A*A))

const int n = 10000000;

int main(int argc, char** argv)
{
  int i;
  double w,x,sum,pi;
  clock_t t;

  t=clock();
/* calculate the interval size */
  w=1.0/n;
  sum=0.0;
#pragma omp parallel private (x) shared(w,sum)
{
#pragma omp for
  for (i=1;i<=n;i++)
  {
    x=w*((double)i-0.5);
    sum=sum+f(x);
  }
}
  pi=w*sum;

  t=clock();
  printf( "computed pi = %24.16g\n", pi );
  printf( "CPU time = %12.4g sec\n", t/1000000.0 );
  return 0;
}
