#include <stdio.h>
#include <time.h>

#define min(A,B) ((A) < (B) ? (A) : (B))
#define max(A,B) ((A) > (B) ? (A) : (B))

#define imax  20
#define kmax  11
#define itmax  20000

void heatpr(double phi[imax+1][kmax+1]);

int main()
{
  double eps = 1.0e-08;
  double phi[imax+1][kmax+1], phin[imax][kmax];
  double dx,dy,dx2,dy2,dx2i,dy2i,dt,dphi,dphimax;
  int i,k,it;

  clock_t t;

  dx=1.0/kmax;
  dy=1.0/imax;
  dx2=dx*dx;
  dy2=dy*dy;
  dx2i=1.0/dx2;
  dy2i=1.0/dy2;
  dt=min(dx2,dy2)/4.0;
/* start values 0.d0 */
  for (k=0;k<kmax;k++)
  {
    for (i=1;i<imax;i++)
    {
      phi[i][k]=0.0;
    }
  }
/* start values 1.d0 */
  for (i=0;i<=imax;i++)
  {
    phi[i][kmax]=1.0;
  }
/* start values dx */
  phi[0][0]=0.0;
  phi[imax][0]=0.0;
  for (k=1;k<kmax;k++)
  {
    phi[0][k]=phi[0][k-1]+dx;
    phi[imax][k]=phi[imax][k-1]+dx;
  }

  printf("\nHeat Conduction 2d\n");
  printf("\ndx = %12.4g, dy = %12.4g, dt = %12.4g, eps = %12.4g\n",
         dx,dy,dt,eps);
  printf("\nstart values\n");
  heatpr(phi);

  t=clock();

/* iteration */
  for (it=1;it<=itmax;it++)
  {
    dphimax=0.;
    for (k=1;k<kmax;k++)
    {
      for (i=1;i<imax;i++)
      {
        dphi=(phi[i+1][k]+phi[i-1][k]-2.*phi[i][k])*dy2i
            +(phi[i][k+1]+phi[i][k-1]-2.*phi[i][k])*dx2i;
        dphi=dphi*dt;
        dphimax=max(dphimax,dphi);
        phin[i][k]=phi[i][k]+dphi;
      }
    }
/* save values */
    for (k=1;k<kmax;k++)
    {
      for (i=1;i<imax;i++)
      {
	phi[i][k]=phin[i][k];
      }
    }
    if(dphimax<eps) break;
  }

  t=clock();
  printf("\nphi after %d iterations\n",it);
  heatpr(phi);
  printf("\nCPU time = %#12.4g sec\n",t/1000000.0);

}

void heatpr(double phi[imax+1][kmax+1])
{
  int i,k,kl,kk,kkk;

  kl=6;
  kkk=kl-1;
  for (k=0;k<=kmax;k=k+kl)
  {
    if(k+kkk>kmax) kkk=kmax-k;
    printf("\ncolumns %5d to %5d\n",k,k+kkk);
    for (i=0;i<=imax;i++)
    {
      printf("%5d ",i);
      for (kk=0;kk<=kkk;kk++)
      {
       printf("%#12.4g",phi[i][k+kk]);
      }
      printf("\n");
    }
  }

return;
}
