/***************************************************************************
                          omp_main6.c  -  description
                             -------------------
    begin                : Tue Jan 30 2001
    copyright            : (C) 2001 by Roman Breuer
    email                : breuer@rz.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 * This program is part of the script:                                     *
 *           Parallelisierung mit OpenMP und MPI.                          *
 *                                                                         *
 ***************************************************************************/

/* minor modifications by Peter Bruehne, ZAIK/RRZK, 19.12.2001 */
/* email: bruehne@rrz.uni-koeln.de                             */
/* inserted comments and                                       */
/* replaced #   pragma  by #pragma for forte 6.2               */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <omp.h>


#define PI 3.1415926535897932384626433832795029L

double f(double a) {
  return (double)4.0/((double)1.0+(a*a));
}

int main(int argc, char *argv[])
{
  long
    n,
    i;

  double
    h,
    pi,
    sum,
    x;


#pragma omp parallel private (i,x)
  {
    for (;;) {
#pragma omp single
      {
        printf("Enter the number of intervals: (0 quits) ");
        scanf("%u",&n);
      }
      /* end omp single */
      if (n==0)
        break;

      h = ((double)1.0)/(double)n;
      sum = 0.0;
#pragma omp barrier

#pragma omp for reduction(+:sum)
      for(i=1;i<=n;i++) {
        x = h*((double)i-(double)0.5);
        sum += f(x);
      }
      /* end omp for */

#pragma omp single
      {
        pi = h*sum;
        printf("  pi is approximatly: %.16f  Error is: %.16f\n",pi,fabs(pi-PI));
      }
      /* end omp single */
    }
  }
  /* end omp parallel */

  return EXIT_SUCCESS;
}
