#include <omp.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
//--------------------------------------------------------------
//			TIME	
//--------------------------------------------------------------
typedef struct _tcs_TIME
{
  struct timeval startzeit;
  struct timeval endzeit;
  struct timezone zeitzone;
} tcs_TIME;

tcs_TIME* tcs_START_TIMER()
{
  tcs_TIME* zeit = (tcs_TIME*) malloc(sizeof(tcs_TIME));
  if( zeit!= NULL)
    gettimeofday(&(zeit->startzeit),&(zeit->zeitzone));
  return zeit;
}

double tcs_STOP_TIMER(tcs_TIME* zeit)
{
  double zeitdifferenz=0.0;
  if(zeit!=NULL)
    {
      gettimeofday(&(zeit->endzeit),&(zeit->zeitzone));
      zeitdifferenz = (double)(zeit->endzeit.tv_sec)+(double)(zeit->endzeit.tv_usec)/1000000.0-((double)(zeit->startzeit.tv_sec)+(double)(zeit->startzeit.tv_usec)/1000000.0); 
      free(zeit);
    }
  else
    fprintf(stderr,"tcs_STOP_TIMER: there was no time difference.\n");
  
  return zeitdifferenz;
}

double tcs_READ_TIMER(tcs_TIME* zeit)
{
  double zeitdifferenz=0.0;
  if(zeit!=NULL)
    {
      gettimeofday(&(zeit->endzeit),&(zeit->zeitzone));
      zeitdifferenz = (double)(zeit->endzeit.tv_sec)+(double)(zeit->endzeit.tv_usec)/1000000.0-((double)(zeit->startzeit.tv_sec)+(double)(zeit->startzeit.tv_usec)/1000000.0); 
    }
  else
    fprintf(stderr,"tcs_READ_TIMER: there was no time difference.\n");
  
  return zeitdifferenz;
}
//----------------------------------------------
//			END OF 'TIME'	
//----------------------------------------------
void nested(int x, int y) 
{ 
  int i,j,sum=0,sum2=0; 
  long int k,l,m;
   tcs_TIME* zeit;
  double zeitdifferenz;
 
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  //			SINGLE PARALLEL SECTION
  //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  omp_set_num_threads(72);
zeit = tcs_START_TIMER(); 
#pragma omp parallel default(shared)
{
#pragma omp for 
    for(i=0;i<x*y;i++)
      {
	  for(k=0;k<9000000;k++)
	  {l=m;m=l;l=2*m;m=34*l+m*m;l=23*m*l*m*l;
	  l=m;m=l;l=2*m;m=34*l+m*m;l=23*m*l*m*l;l=m;m=l;l=2*m;m=34*l+m*m;l=23*m*l*m*l;l=m;}
 				  //printf(" Thread number %d\n",omp_get_thread_num());
      }	
} //end of #parallel
 zeitdifferenz= tcs_STOP_TIMER(zeit);
 fprintf(stdout,"Time for single parallel section: %f\n", zeitdifferenz); 
 
 //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 //			NESTED PARALLELISM 	  
 //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  omp_set_num_threads(72);
  omp_set_nested(1);
zeit = tcs_START_TIMER(); 
#pragma omp parallel default(shared)
{
#pragma omp for 
    for(i=0;i<x;i++)
      {
			      		
      #pragma omp parallel 
      {
        #pragma omp for 
      	for(j=0;j<y;j++)
	{
	  for(k=0;k<9000000;k++)
	  {l=m;m=l;l=2*m;m=34*l+m*m;l=23*m*l*m*l;
	  l=m;m=l;l=2*m;m=34*l+m*m;l=23*m*l*m*l;l=m;m=l;l=2*m;m=34*l+m*m;l=23*m*l*m*l;l=m;}
 				  //printf(" Thread number %d\n",omp_get_thread_num());
	}
      }	
		      		
      }
} //end of #parallel
 zeitdifferenz= tcs_STOP_TIMER(zeit);
 fprintf(stdout,"Time for nested parallelism: %f\n", zeitdifferenz); 
 //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
}

int main (int argc,char *argv[])
{
  int x,y;
  x=atoi(argv[1]);
  y=atoi(argv[2]);
  
  nested(x,y); 
}
