#include<stdlib.h>
#include<stdio.h>
#include<math.h>
#include<time.h>
#define N_MAX 1000

/* Sequential Program to Calculate Gravitational Evolution */

double elapsed_time(const timespec_t t2, const timespec_t t1);

void main(int argc,char* argv[])
{	double dt,dtsq,rsqinv,ftmp,gamma,dx,dy,dVx,dVy;
	double *m,*x,*y,*Vx,*Vy,*Fx,*Fy,Px,Py,P,td;
	const double G=6.673;
	int    n,t,nt,i,j;
	timespec_t t1,t2;
    
        if (argc > 1) n=atoi(argv[1]);
	n=( n > 0 && n <= N_MAX ) ? n : N_MAX;
	nt=1e2; dt=1e-1/nt; dtsq=0.5*dt*dt;
        gamma=G*dt;

	/* allocate arrays */
	m= (double*) malloc(n*sizeof(double));
	x= (double*) malloc(n*sizeof(double));
	y= (double*) malloc(n*sizeof(double));
	Vx=(double*) malloc(n*sizeof(double));
	Vy=(double*) malloc(n*sizeof(double));
	Fx=(double*) malloc(n*sizeof(double));
	Fy=(double*) malloc(n*sizeof(double));
	
	/* initialize arrays */
	for(i=0;i<n;i++)
	{	m[i]=1.0;
		x[i]=(10.0*i)/(n-1); y[i]=x[i]; 
		Vx[i]=0.0;  Vy[i]=0.0;
 		Fx[i]=0.0;  Fy[i]=0.0;
	}


	/* show initial momentum */
	for(j=0,Px=0,Py=0;j<n;j++) { Px+=m[j]*Vx[j]; Py+=m[j]*Vy[j];}
	P=Px*Px+Py*Py; printf("t = 0, total momentum = %lf \n\n",P);
	    

	clock_gettime(CLOCK_SGI_CYCLE,&t1);
	
	for(t=1; t<=nt; t++) {	                            
		for(i=0; i<n; i++) { /* calculate forces */
			for(j=0; j<n; j++) if(j!=i) { 
				dx=x[j]-x[i]; dy=y[j]-y[i];
				rsqinv=1/(dx*dx+dy*dy);
				ftmp=m[j]*rsqinv*sqrt(rsqinv);
				Fx[i]+=ftmp*dx; Fy[i]+=ftmp*dy;
			}
		} 
         
		for(i=0; i<n; i++) { /* update position/velocity */
			dVx=Fx[i]*gamma; dVy=Fy[i]*gamma;   
			x[i]+=Vx[i]*dt+dVx*dtsq;
			y[i]+=Vy[i]*dt+dVy*dtsq;
			Vx[i]+=dVx; Vy[i]+=dVy;
		}
		
		for(j=0,Px=0,Py=0;j<n;j++) { Px+=m[j]*Vx[j]; Py+=m[j]*Vy[j];}
		P=Px*Px+Py*Py; printf("t = %d, total momentum = %lf \n\n",t,P);
	    

	}

	clock_gettime(CLOCK_SGI_CYCLE,&t2);
	td = elapsed_time(t2,t1);
	printf("%d elements, time per iteration/element = %6.1f ns\n",n,(td * 1E9) / (nt*n));


}



/*
 * elapsed time in seconds for POSIX-compliant clocks
 */
double elapsed_time(const timespec_t t2, const timespec_t t1)
{
   return   (((double)t2.tv_sec) + ((double)t2.tv_nsec / 1e9)) 
          - (((double)t1.tv_sec) + ((double)t1.tv_nsec / 1e9));
}

