#include <stdio.h>

#ifdef _OPENMP
#include <omp.h>
#endif

#define NMAX 3000

int main(int argc, char *argv[])

{
  /* local scalars */
  int i,j,n;
  double a[NMAX], c[NMAX], b[NMAX][NMAX];

  n=NMAX;

  /* Initialisation */
  for(i=0;i<NMAX;i++) 
    {
      a[i]=1;
      c[i]=2;
    }

  for(j=0;j<NMAX;j++) 
    {
      for(i=0;i<NMAX;i++)
	{
	  b[j][i]=3;
	}
    }

  printf("doing computation ...\n");

  for(j=0;j<n;j++) 
    {
      #pragma omp parallel for
      for(i=0;i<n;i++)
	{
	  a[i] = a[i] + b[i][j]*c[j];
	}
      /* end omp parallel for */
    }

  printf("done. %f\n",a[0]);
  
  return 0;
}
