program heat

! 2D heat conduction
! using parallel dos

integer, parameter      :: imax=20,kmax=11,itmax=20000
real(kind=8), parameter :: eps=1.e-8_8
real(kind=8), dimension(0:imax,0:kmax)     :: phi
real(kind=8), dimension(1:imax-1,1:kmax-1) :: phin
real(kind=8) dx,dy,dx2,dy2,dx2i,dy2i,dt,dphi,dphimax

! times using dtime
real, dimension(2) :: tarray

! times using system_clock
integer sccb,scce,sccr,sccm
real(kind=8) sccd,scdiff

dx=1.0_8/kmax
dy=1.0_8/imax
dx2=dx*dx
dy2=dy*dy
dx2i=1.0_8/dx2
dy2i=1.0_8/dy2
dt=min(dx2,dy2)/4.0_8

! start values 0.d0
!$OMP PARALLEL DO PRIVATE(i,k), SHARED(phi)
do k=0,kmax-1
do i=1,imax-1
   phi(i,k)=0.0_8
enddo
enddo
!$OMP END PARALLEL DO

! start values 1.d0
!$OMP PARALLEL DO PRIVATE(i), SHARED(phi)
do i=0,imax
   phi(i,kmax)=1.0_8
enddo
!$OMP END PARALLEL DO

! start values dx
phi(0,0)=0.0_8
phi(imax,0)=0.0_8
do k=1,kmax-1
   phi(0,k)=phi(0,k-1)+dx
   phi(imax,k)=phi(imax,k-1)+dx
enddo

! print
write (*,'(/,a)') 'Heat Conduction 2d'
write (*,'(/,4(a,1pg12.4))') 'dx =',dx,', dy =',dy,', dt =',dt,', eps =',eps
write (*,'(/,a)') 'start values'
call heatpr(phi,imax,kmax)

t0=dtime(tarray)

call system_clock(count=sccb,count_rate=sccr,count_max=sccm)

! iteration
do it=1,itmax
   dphimax=0.
!$OMP PARALLEL DO PRIVATE(i,k,dphi), SHARED(phi,phin,dx2i,dy2i,dt) &
!$OMP& REDUCTION(max:dphimax)
   do k=1,kmax-1
   do i=1,imax-1
      dphi=(phi(i+1,k)+phi(i-1,k)-2.0_8*phi(i,k))*dy2i  &
          +(phi(i,k+1)+phi(i,k-1)-2.0_8*phi(i,k))*dx2i
      dphi=dphi*dt
      dphimax=max(dphimax,dphi)
      phin(i,k)=phi(i,k)+dphi
   enddo
   enddo
!$OMP END PARALLEL DO

! save values
!$OMP PARALLEL DO PRIVATE(i,k), SHARED(phi,phin)
   do k=1,kmax-1
   do i=1,imax-1
      phi(i,k)=phin(i,k)
   enddo
   enddo
!$OMP END PARALLEL DO

! genauigkeit erreicht?
   if(dphimax.lt.eps) goto 10
enddo

10 continue

t1=dtime(tarray)

call system_clock(count=scce,count_rate=sccr,count_max=sccm)
sccd=scdiff(sccb,scce,sccr,sccm)

! print
write (*,'(/,a,i8,a)')         'iterations:        ',it
call heatpr(phi,imax,kmax)
write (*,'(/,2(a,1pg12.4,/))') 'dtime user time:   ', tarray(1), &
                               'dtime system time: ', tarray(2)
write (*,'(/,a,1pg12.4,a)')    'system clock time: ',sccd,' seconds'

stop
end program heat




subroutine heatpr(phi,imax,kmax)
real(kind=8), dimension(0:imax,0:kmax)     :: phi

kl=6
kkk=kl-1
do k=0,kmax,kl
   if(k+kkk.gt.kmax) kkk=kmax-k
   write (*,'(/,a,i5,a,i5)') 'columns',k,' to',k+kkk
   do i=0,imax
      write (*,'(i5,6(1pg12.4))') i,(phi(i,k+kk),kk=0,kkk)
   enddo
enddo

return
end subroutine heatpr
