/** This is Ancre-PILS,
 the non-parametric rational version of PILS.
@author B. Meister, 
@version 1.01, 02 oct 2005 
Uses polylib. */

#ifndef __BM_ANCRE_PILS_HLP_H_
#define __BM_ANCRE_PILS_HLP_H_


#include<polylib/polylibgmp.h>
#include<assert.h>

/* the rank of the constraint that is maximum wrt the order vector */
int max_scalar(Matrix * cons, Matrix * order, int cur_o, Matrix * permanent);

/* tests if the row^th row-vector of matrix M is zero */
int zero_vector(Matrix *M, unsigned row);

/* solves a Hierarchcially Linear Programming (HLP) problem. */
Matrix * HLP_solve(Matrix * cons, Matrix * order, unsigned MAXRAYS);


#endif /* __BM_ANCRE_PILS_HLP_H_ */
