/*     cassage de domaine
*/

/* Saisit n (tq T^n=Id), T et le domaine En */

#include <stdio.h>
#include <stdlib.h>
#include <polylib/polylib64.h>

#define WS 1000
#define AFF_POLY(P) {	fprintf( stderr, "\n"#P" = "); \
                        Polyhedron_Print( stderr, "%3d ", P ); }

#define AFFCONTRAINTES(p) {	printf( "\n# "#p "\n" ); \
                        AffContraintes( p ); }

int Aff( int i )
{
	if( i==0 ) return 0;
	if( i==1 ) { printf( "+" ); return 1; }
	if( i==-1 ) { printf( "-" ); return -1; }
	else if( i>0 ) printf( "+%d", i );
	else printf( "%d", i );
	return( i );
}
void AffContraintes( Polyhedron *p )
{
	int i,j;
	for( ; p ; p=p->next )
	{
		printf( "%d %d\n", p->NbConstraints, p->Dimension+2 );
		for( i=0 ; i<p->NbConstraints ; i++ )
		{
		 for( j=0 ; j<p->Dimension+2 ; j++ )
				printf( "%3lld ", p->Constraint[i][j] );
		 if( p->Dimension == 3 )
		 {
			printf( "   # " );
			if( p->Constraint[i][1]>0 || (p->Constraint[i][1]==0 && p->Constraint[i][2]>0) )
			{
				if(Aff(p->Constraint[i][1])) printf( "i " );
				if(Aff(p->Constraint[i][2])) printf( "j " );
				if( p->Constraint[i][0] == 1 )
					printf( "\\ge " );
				else
					printf( "= " );
				if(Aff(-p->Constraint[i][3])) printf( "N " );
				if( abs(Aff(-p->Constraint[i][4]))==1 )
					printf( "%d",abs(p->Constraint[i][4]) );
			}
			else if( p->Constraint[i][1]==0 && p->Constraint[i][2]==0 )
				printf("No i, j");
			else
			{
				if(Aff(-p->Constraint[i][1])) printf( "i ");
				if(Aff(-p->Constraint[i][2])) printf( "j ");
				if( p->Constraint[i][0] == 1 )
					printf( "\\le " );
				else
					printf( "= " );
				if(Aff(p->Constraint[i][3])) printf( "N ");
				if( abs(Aff(p->Constraint[i][4]))==1 )
					printf( "%d",abs(p->Constraint[i][4]) );
			}
		 }
		 printf( "\n" );
		}
	}
}

int Matrice_identite( Matrix *M )
{
	int i,j;
	if( M->NbRows != M->NbColumns )
		return( 0 );
	for( i=0 ; i<M->NbRows ; i++ )
		for( j=0 ; j<M->NbColumns ; j++ )
			if( i == j )
			{
				if( M->p[i][j] != 1 )
					return( 0 );
			}
			else
			{
				if( M->p[i][j] != 0 )
					return( 0 );
			}
	return( 1 );
}

int main(int argc, char *argv[])
{
	int s;
	Matrix *r1, *r2, *ri;
	Matrix *T, *en, *context;
	Polyhedron  *D, *C;
	Polyhedron *P1, *P2, *D1, *D2, *L, *p;
	int i,j;

/*	scanf( "%d", &n ); */

/*	T = Matrix_Read(); */
	r1 = Matrix_Read();
	r2 = Matrix_Read();
	s = r1->NbColumns;
	if( s != r2->NbColumns || s != r2->NbRows || s != r1->NbRows )
	{
		fprintf(stderr,
		"Les matrices r1 et r2 doivent etre carrees et avoir la meme taille\n" );
		exit(0);
	}
	ri = Matrix_Alloc(s, s+1);
	if( !MatInverse( r2, ri ) )
	{
		fprintf( stderr, "r2 non inversible!\n");
		exit(0);
	}


	T = Matrix_Alloc(s, s );
	for( i=0 ; i<s ; i++ )
		for( j=0 ; j<s ; j++ )
		{
			int z,k;
			z=0;
			for( k=0 ; k<s ; k++ )
				z += ri->p[i][k] * r1->p[k][j];
			if( z % ri->p[i][s] != 0 )
			{
				fprintf(stderr,
					"Les matrices r1 et r2 n'ont pas le meme determinant\n" );
				exit(0);
			}
			T->p[i][j] = z / ri->p[i][s];
		}
	Matrix_Free( ri );
	Matrix_Free( r1 );
	Matrix_Free( r2 );

	en = Matrix_Read();
	D = Constraints2Polyhedron(en, WS );
	Matrix_Free(en);

	context = Matrix_Read();

	fprintf( stderr, "T = ");
	Matrix_Print( stderr, "%3d ", T );
	if( T->NbColumns != D->Dimension+1 || T->NbColumns != T->NbRows )
	{
		fprintf(stderr,
		"Matrice T incompatible avec la dimension de D !\n" );
		exit(0);
	}



	/* calcul de C */
	C = DomainIntersection( 
			DomainIntersection( D, DomainPreimage(D,T,WS), WS),
			DomainImage(D,T,WS),
			WS);
AFF_POLY(C);
	/* calcul de D1, D2, L */
	p = DomainPreimage( D, T, WS );
	P1 = DomainIntersection( D, p, WS );
	Domain_Free( p );
	p = DomainImage( D, T, WS );
	P2 = DomainIntersection( D, p, WS );
	Domain_Free( p );
	D1 = DomainDifference( P1, P2, WS);
	D2 = DomainDifference( P2, P1, WS);
	p = DomainDifference( D, P1, WS );
	L = DomainDifference( p, P2, WS );
	Domain_Free( p );

/*
AFFCONTRAINTES( P1 );
AFFCONTRAINTES( P2 );
*/
AFFCONTRAINTES( D1 );
AFFCONTRAINTES( D2 );
AFFCONTRAINTES( C );
	AFF_POLY(D1);
	AFF_POLY(D2);
AFFCONTRAINTES( L );

Matrix_Print(stdout, "%3d ", context );

	/* il faudrait faire des free... */
	return 0;
}

