/*
   input : t1 trans (homogeneous)
           t2 trans (homogeneous)
           D polyhedron
           C Context

computes T1^-1 T2 D and T2^-1 T1 D, and their disjoint union

   output : loop scanning each of the 4 part

*/

#include <stdio.h>
/*
#include "types.h"
#include "vector.h"
#include "polyhedron.h"
#include "polyparam.h"
*/
#include <polylib/polylib32.h>

/*
Polyhedron *Polyhedron_Scan( Polyhedron *D,  Polyhedron *C, int MAXRAYS );
#define Vector_Init(p1, length) \
  memset((char *)(p1), 0, (int)(length)*sizeof(int))
*/

#define AFF_SCAN(P) \
	fprintf( stderr, "SCAN :\n" ); \
	for( p=P ; p ; p = p->next ) \
	{ \
		Polyhedron *pt, *scan; \
		pt = p->next; \
		p->next = NULL; \
		scan = Polyhedron_Scan( p, Con, 200 ); \
		for( ; scan ; scan = scan->next ) \
		{ \
			Matrix_Print( stderr, "%4d ", Polyhedron2Constraints(scan)); \
			if( scan->next ) \
				fprintf( stderr, "AND\n"); \
		} \
		if( (p->next = pt) ) \
			fprintf( stderr, "\nUNION\n"); \
	}

int main()
{
    Matrix *b, *t1, *t2, *con;
    Polyhedron *D,  *Con, *I, *I12, *I21, *R;
	Polyhedron *Tm2 , *Tm1, *p ;

/******************************************************************/
    t1 = Matrix_Read();
    t2 = Matrix_Read();

    b = Matrix_Read();
    D = Constraints2Polyhedron(b, 200);
    Matrix_Free(b);

	con = Matrix_Read();
	Con = Constraints2Polyhedron(con, 200);
/******************************************************************/

	Tm1 = DomainPreimage(DomainImage(D,t2,200),t1,200);

/*	printf( " T1^-1 T2 D = ");
	Matrix_Print( stdout, "%4d ", Polyhedron2Constraints(Tm1) );
*/

	Tm2 = DomainPreimage(DomainImage(D,t1,200),t2,200);
/*	printf( " T2^-1 T1 D =\n");
	Matrix_Print( stdout, "%4d ", Polyhedron2Constraints(Tm2) );
*/

/******************************************************************/
	I = DomainIntersection( Tm1, DomainIntersection( Tm2, D, 200 ), 200 );
	printf("\n# I = D \\inter T21 \\inter T12 =\n");
	Matrix_Print( stdout, "%4d ", Polyhedron2Constraints(I));

	I12 = DomainDifference( DomainIntersection(Tm1, D, 200), Tm2, 200 );
	printf("\n# I12 = D \\inter (T12 - T21) =\n" );
	Matrix_Print( stdout, "%4d ", Polyhedron2Constraints(I12));

	I21 = DomainDifference( DomainIntersection(Tm2, D, 200), Tm1, 200 );
	printf("\n# I21 = D \\inter (T21 - T12) =\n" );
	Matrix_Print( stdout, "%4d ", Polyhedron2Constraints(I21));

	R = DomainDifference( D, DomainUnion(Tm1, Tm2, 200), 200 );
	printf("\n# Reste = D - (T21 \\union T12) =\n" );
	Matrix_Print( stdout, "%4d ", Polyhedron2Constraints(R));

	printf( "\n");
	Matrix_Print( stdout, "%4d ", con );

	fprintf( stderr, "\n\nI :\n" );
	AFF_SCAN( I );
	fprintf( stderr, "\nI12 :\n" );
	AFF_SCAN( I12 );
	fprintf( stderr, "\nI21 :\n" );
	AFF_SCAN( I21 );
	fprintf( stderr, "\nR :\n" );
	AFF_SCAN( R );


    return 0;
}


