/* comparaison de la macro DIVIDE et de la routine divide du
   package arithmetique */

#include <stdio.h>

#include "assert.h"
#include "arithmetique.h"

/* tirage aleatoire de TEST_NUMBER paires de nombres entiers et verification
 * des predicats arithmetiques sur la division, le modulo et le pgcd
 *
 * Etude de l'effet de la look-up table en limitant les tirages a 
 * l'intervalle [0..15]
 */
main()
{
#define TEST_NUMBER 200000
    int i; /* compte de tests */
    int a, b; /* paire a tester */
    /* resultats par la fonction et par la macro */
    int quotient_f, quotient_m;

    for(i=0; i<TEST_NUMBER; i++) {
	/* calcul de la paire aleatoire */
	a = (int) rand() & 7;
	/* recherche d'un b non nul */
	for(b = 0; b==0; b = ((int) rand()) & 7)
	    ;

	/* appel des fonctions a tester */
	quotient_f = divide_fast(a,b);
	quotient_m = divide_slow(a,b);

	assert(quotient_f==quotient_m);
    }
}
