/* types-polylib.h
     COPYRIGHT
          Both this software and its documentation are

              Copyright 1993, IRISA /Universite de Rennes I - France
              Copyright 1996,1997,1998, Doran Wilde and Vincent Loechner
              All rights reserved.

          Permission is granted to copy, use, and distribute
          for any commercial or noncommercial purpose under the terms
          of the GNU General Public license, version 2, June 1991
          (see file : LICENSING).
*/
#ifndef _types_polylib_h_
#define _types_polylib_h_

/*********************** User defines ******************************/

/* first parameter name char.  */
#define FIRST_PARAMETER_NAME 'P'

/******************* End of user defines ***************************/

#define PCHAR (FIRST_PARAMETER_NAME-1)

#include <stdio.h>
#include "arithmetique.h"

#if defined(LINEAR_VALUE_IS_LONGLONG)
#define P_VALUE_FMT "%4lld "
#elif defined(LINEAR_VALUE_IS_LONG)
#define P_VALUE_FMT "%4ld "
#elif defined(LINEAR_VALUE_IS_CHARS)
#define P_VALUE_FMT "%s "
#else /* default: LINEAR_VALUE_IS_INT */
#define P_VALUE_FMT "%4d "
#endif


/* MSB, TOP, and NEXT are defined over integers, not values */
/* put a one in the MSB of an int (portable) */
#define MSB ((unsigned)1<<(sizeof(int)*8-1))
/* largest representable positive number */
#define TOP ((int)(MSB-1))

#define NEXT(j,b) { if (!((b)>>=1)) { (b)=MSB; (j)++; } }

/* Used in lower_upper_bounds : */
#define LB_INFINITY 1
#define UB_INFINITY 2

/* status of last Polyhedron operation */
extern int Pol_status;

typedef struct vector {
  unsigned Size;
  Value *p;
} Vector;

#define Vector_Copy(p1, p2, length) \
  memcpy((char *)(p2), (char *)(p1), (int)((length)*sizeof(Value)))

#define Vector_Init(p1, length) \
  memset((char *)(p1), 0, (int)((length)*sizeof(Value)))

#define Vector_Exchange(a, b, t, l)\
{\
  memcpy((char *)(t), (char *)(a), (int)((l)*sizeof(Value)));\
  memcpy((char *)(a), (char *)(b), (int)((l)*sizeof(Value)));\
  memcpy((char *)(b), (char *)(t), (int)((l)*sizeof(Value)));\
}


typedef struct matrix {
  unsigned NbRows, NbColumns;
  Value **p;
  Value *p_Init;
} Matrix;

typedef struct polyhedron
{ struct polyhedron *next;
  unsigned Dimension, NbConstraints, NbRays, NbEq, NbBid;
  Value **Constraint;
  Value **Ray;
  Value *p_Init;
} Polyhedron;

typedef struct
{ Value MaxN, MaxD; int MaxI; Value MinN, MinD; int MinI; } Interval;

/* #define emptyQ(P) (P->NbEq==(P->Dimension+1)) */
#define emptyQ(P) (P->NbRays==0)
#define universeQ(P) (P->Dimension==P->NbLines)

typedef struct _Param_V
{	struct _Param_V *next;	/* ptr to the next vertex, NULL terminated */
	Matrix *Vertex;			/* Each line is a coordinate of the vertex: */
				/* the first m values of each line are the */
				/* coefficients of the parameters, */
				/* the (m+1)th value is the constant, */
				/* the (m+2)th value is the common denom */
	Matrix *Domain;			/* Constraints on parameters */
									/* Inequalities only. (Polyhedron format) */
}
Param_Vertices;

typedef struct _Param_Domain
{
	struct _Param_Domain *next; /* ptr to next record in list, null term. */
	Polyhedron *Domain;		/* ptr to Domain (constraints on parameters) */
	int	*F;					/* bit array of faces */
} Param_Domain;

typedef struct _Param_Poly
{	int		nbV;	/* number of parameterized vertices */
	Param_Vertices *V;		/* linked list of parameterized vertices */
	Param_Domain   *D;		/* linked list of validity domains */
}
Param_Polyhedron;

/* A FOR loop for scanning the vertices of a parameterized polyhedron */
/* Example usage:                                                     */
/* (declarations)                                                     */
/*       Param_Polyhedron *P;                                         */
/*       Param_Domain     *D;                                         */
/*       Param_Vertices   *V;                                         */
/* (code)                                                             */
/*       FORALL_PVertex_in_ParamPolyhedron( V, D, P )                 */
/*       {                                                            */
/*               Print_Vertex( stdout, V->Vertex );                   */
/*               printf( "\n" );                                      */
/*       }                                                            */
/*       END_FORALL_PVertex_in_ParamPolyhedron;                       */

#define FORALL_PVertex_in_ParamPolyhedron(V, D, P)   \
{     int _i, _ix;                                   \
      unsigned _bx;                                  \
      for( _i=0, _ix=0, _bx=MSB, V=P->V ;            \
           V && (_i<P->nbV) ; _i++, V=V->next )      \
      {       if (D->F[_ix] & _bx)                   \
              {

#define END_FORALL_PVertex_in_ParamPolyhedron  \
              }                                \
              NEXT(_ix, _bx);                  \
      }                                        \
}

/* data structures for a pseudo-polynomial */

typedef enum { polynomial, periodic, evector } enode_type;

typedef struct _evalue		/* rational number or pointer */
        {
		    Value d;		/* denominator */
          union
          {
			    Value n;		/* numerator (if denominator != 0) */
             struct _enode *p;	/* pointer   (if denominator == 0) */
          } x;
        } evalue;

typedef struct _enode
        {  enode_type type;	/* polynomial or periodic */
           int size;            /* number of attached pointers */
           int pos;		/* parameter position */
           evalue arr [1];	/* array of rational/pointer */
        } enode;

typedef struct _enumeration
{
	struct _enumeration *next;  /* next in the list                  */
	Polyhedron *ValidityDomain; /* contraints on the parameters      */
	evalue EP;                  /* Ehrhart Polynomial, corresponding
	                               to parameter values inside the
	                               domain ValidityDomain below       */
} Enumeration;

/*-----------------------------Example Usage------------------------------*/
/* enode *e                                                               */
/*     e->type = polynomial     e->type = periodic   e->type = evector    */
/*     e->size = degree+1       e->size = period     e->size = length     */
/*     e->pos  = [1..nb_param]                                            */
/*     e->arr[i].d = denominator (Value)                                  */
/*     e->arr[i].x.p = pointer to another enode (if denominator is zero)  */
/*     e->arr[i].x.n = numerator (Value) (if denominator is non-zero)     */
/*------------------------------------------------------------------------*/

/*------------------------------------------------------------------------*/
/* This representation has the following advantages:                      */
/*   -- its dynamic, it can grow/shrink easily                            */
/*   -- it is easy to evaluate for a given context (values of parameters) */
/*   -- it allows pseudo-polynomial to be reduced with rules              */
/*   -- it can be constructed recursively                                 */
/*------------------------------------------------------------------------*/

#ifndef FOREVER
#define FOREVER for(;;)
#endif


#endif /* _types_polylib_h_ */
