#include <stdio.h>

#include "arithmetique.h"
#include "polylib.h"

int main()
{
	Matrix *a, *b;
	Polyhedron *A, *B;
	Param_Polyhedron *PA;

	a = Matrix_Read();
	A = Constraints2Polyhedron(a, 200);
	Matrix_Free(a);

	b = Matrix_Read();
	B = Constraints2Polyhedron(b, 200);
	Matrix_Free(b);

	PA = Polyhedron2Param_Vertices( A, B, 500 );

	Param_Vertices_Print( stdout, PA->V );

	Domain_Free(A);
	Domain_Free(B);
	Param_Polyhedron_Free( PA );

	return 0;
}
