#include <stdio.h>              // Pour printf()
#include <stdlib.h>             // Pour exit(), NULL
#include <unistd.h>             // Pour pause()
#include <fcntl.h>              // Pour open(), O_CREAT O_WRONLY
#include <signal.h>             // Pour signal()
#include <sys/types.h>          // Pour key_t
#include <sys/ipc.h>            // Pour ftok(), IPC_CREAT, IPC_RMID
#include <sys/shm.h>            // Pour shmget(), shmat(), shmdt(), shmctl()

#include "def.h"                // Pour SHM_CHEMIN et SHM_ID

int shmid;                      // Identificateur du segment
int * shmadr;                   // Adresse d'attachement du segment

/* Fonction executee a la reception du signal SIGINT. */
void traitant_sigint(int numero_signal) {
  shmdt(shmadr);                // Detachement du segment
  shmctl(shmid, IPC_RMID, NULL);// Destruction du segment
  exit(0);
}

/* Fonction creant un segment de memoire partagee de 'taille' octets et dont
 * la cle est construite a partir de 'chemin_fichier' et de 'identificateur'.
 * Cette fonction retourne l'identificateur du segment.
 */
int shm_creation(char * chemin_fichier, int identificateur, int taille) {
  int fd, shmid;
  key_t cle;

  // Creation du fichier 'chemin_fichier' pour generer la cle.
  fd = open(chemin_fichier, O_CREAT|O_WRONLY, 0644);
  close(fd);

  // Generation de la cle a partir de 'chemin_fichier' et 'identificateur'.
  cle = ftok(chemin_fichier, identificateur);

  // Creation d'un segment de memoire partagee de 'taille' octets.
  shmid = shmget(cle, taille, IPC_CREAT|0666);
  
  return shmid;
}

int main() {
  // Creation du segment de memoire partagee de taille un entier.
  shmid = shm_creation(SHM_CHEMIN, SHM_ID, sizeof(int));
  
  // Attachement du segment et recuperation de son adresse.
  shmadr = (int *)shmat(shmid, NULL, 0);

  // Initialisation a 20 de l'entier contenu dans le segment.
  *shmadr = 20;
  
  printf("parking : identificateur=%d, places=%d.\n", shmid, *shmadr);

  // Deroutement de SIGINT et endormissement jusqu'a reception d'un signal.
  signal(SIGINT, traitant_sigint);
  pause();
  
  return 0;
}
