#include <fcntl.h>
#include <sys/sem.h>
#include <sys/types.h>
#include <sys/ipc.h>

/* Effectue l'operation P pour le semaphore sem. */
void easysem_P(int sem) {
  struct sembuf action;  // Declaration d'une structure d'operation.
  
  action.sem_num =  0;   // On agit sur le semaphore 0 de l'ensemble.
  action.sem_op  = -1;   // On veut faire une operation P.
  action.sem_flg =  0;   // Pas d'option.
  semop(sem, &action, 1);// On realise l'operation (une seule, dans &action).
}

/* Effectue l'operation V pour le semaphore sem. */
void easysem_V(int sem) {
  struct sembuf action;  // Declaration d'une structure d'operation.
  
  action.sem_num =  0;   // On agit sur le semaphore 0 de l'ensemble.
  action.sem_op  =  1;   // On veut faire une operation V.
  action.sem_flg =  0;   // Pas d'option.
  semop(sem, &action, 1);// On realise l'operation (une seule, dans &action).
}

/* Cree un semaphore avec une ressource et retourne son descripteur,
 * la cle du semaphore est generee a l'aide du fichier designe par le
 * parametre chemin_fichier.
 */
int easysem_create(char * chemin_fichier) {
  int fd, semid;
  key_t cle;

  // Creation du fichier 'chemin_fichier' pour generer la cle.
  fd = open(chemin_fichier, O_CREAT|O_WRONLY, 0644);
  close(fd);

  // Generation de la cle a partir de 'chemin_fichier'.
  cle = ftok(chemin_fichier, (int)chemin_fichier[0]);

  // On cree un ensemble de 1 semaphore.
  semid = semget(cle, 1, IPC_CREAT|0666);

  // On donne une ressource. 
  easysem_V(semid);
  
  return semid;
}

/* Retourne le descripteur d'un semaphore dont la cle est generee a l'aide
 * du fichier designe par le  parametre chemin_fichier.
 */
int easysem_getid(char * chemin_fichier) {
  int fd, semid;
  key_t cle;

  // Generation de la cle a partir de 'chemin_fichier'.
  cle = ftok(chemin_fichier, (int)chemin_fichier[0]);

  // On recupere l'identificateur du semaphore.
  semid = semget(cle, 1, 0);
  
  return semid;  
}

/* Demande au systeme la destruction du semaphore d'identificateur sem. */
void easysem_destroy(int sem) {
  semctl(sem, 0, IPC_RMID);
}
