package notation_v2;

public class Notes {
	private float[] notes;
	private int nbNotes=0;
	
	/**
	 * Constructeur, l'argument est la taille maxi du tableau de notes.
	 */
	public Notes(int tailleNotes) {
		notes = new float[tailleNotes]; // On cree l'objet tableau.
	}

	/**
	 * Methode pour ajouter une note a la liste. Retourne true si la note
	 * a pu etre ajoutee, false sinon.
	 */
	public boolean ajouterNote(float note) {
		if (note>20){return false;}
		else if (note<0){return false;} 
		notes[getNbNotes()] = note; // On ajoute la note dans le tableau.
		nbNotes++;             // On marque qu'une note a ete ajoutee.
		return true;
	}

	/**
	 * Methode pour afficher les statistiques.
	 */
	public void afficherStatistiques() {
		int i ;
		System.out.print("Les notes sont    = ");
		for (i=0;i<nbNotes;i++)
			System.out.print(notes[i]+" ");
		System.out.println() ;
		System.out.println("Nombre de notes   = " + getNbNotes());
		System.out.println("Moyenne des notes = " + getMoyNotes());
		System.out.println("Note maximale     = " + getMaxNotes());
		System.out.println("Note minimale     = " + getMinNotes());
	}

	public float getMoyNotes() {
		float somme=0;
		for (int i=0;i<getNbNotes();i++)
			{somme+=notes[i];}
		return somme/getNbNotes();
	}
	
	public float getMaxNotes() {
		float max=0;
		for (int i=0;i<getNbNotes();i++)
			{max=Math.max(notes[i],max);}
		return max;	
	}
	
	public float getMinNotes() {
		float min=20;
		for (int i=0;i<getNbNotes();i++)
			{min=Math.min(notes[i],min);}
		return min;
	}
	
	public int getNbNotes() {
		return nbNotes;
	}
}


