package notation;
/**
 * Classe destinee a contenir une liste de notes et maintenir des statistiques sur
 * ces notes.
 * 
 * @author Bastoul
 * 
 */
public class Notes {
	
	/** 
	 * Constante definissant la note maximale.
	 */
	public static final float MAX_NOTE = 20;
	
	/**
	 * Constante definissant la note minimale.
	 */
	public static final float MIN_NOTE = 0;

	/**
	 * Le tableau de notes.
	 */
	public float[] notes;
	
	/**
	 * La moyenne des notes.
	 */
	public float moyNotes = 0;
	
	/**
	 * Note maximale de la liste.
	 */
	public float maxNotes = MIN_NOTE;
	
	/**
	 * Note minimale de la liste.
	 */
	public float minNotes = MAX_NOTE;

	/**
	 * Capacite du tableau de notes.
	 */
	public int tailleNotes;
	
	/**
	 * Nombre de notes deja entrees.
	 */
	public int nbNotes = 0;

	/**
	 * Constructeur, l'argument est la taille maxi du tableau de notes.
	 */
	public Notes(int tailleNotes) {
		notes = new float[tailleNotes]; // On cree l'objet tableau.
		this.tailleNotes = tailleNotes; // On enregistre la taille maxi du
										// tableau.
	}

	/**
	 * Methode pour ajouter une note a la liste. Retourne true si la note
	 * a pu etre ajoutee, false sinon.
	 */
	public boolean ajouterNote(float note) {
		
		if (tableauPlein() || !noteCorrecte(note))
			return false;      // Si probleme, on retourne false
		
		notes[nbNotes] = note; // On ajoute la note dans le tableau.
		nbNotes++;             // On marque qu'une note a ete ajoutee.
		miseAJour();           // On met a jour les statistiques.
		return true;
	}

	/**
	 * Methode pour afficher les statistiques.
	 */
	public void afficherStatistiques() {
		int i ;
		System.out.print("Les notes sont    = ");
		for (i=0;i<nbNotes;i++)
			System.out.print(notes[i]+" ");
		System.out.println() ;
		System.out.println("Nombre de notes   = " + nbNotes);
		System.out.println("Moyenne des notes = " + moyNotes);
		System.out.println("Note maximale     = " + maxNotes);
		System.out.println("Note minimale     = " + minNotes);
	}

	/**
	 * Methode pour mettre a jour les statistiques apres ajout d'une note.
	 */
	private void miseAJour() {
		if (notes[nbNotes - 1] > maxNotes)
			maxNotes = notes[nbNotes - 1];

		if (notes[nbNotes - 1] < minNotes)
			minNotes = notes[nbNotes - 1];

		moyNotes = ((moyNotes * (nbNotes - 1)) + notes[nbNotes - 1]) / nbNotes;
	}

	/**
	 * Methode pour verifier qu'il y a encore de la place pour ajouter une note.
	 * Retourne true s'il y a encore de la place, false sinon.
	 */
	private boolean tableauPlein() {
		if (nbNotes >= tailleNotes) {
			System.out.println("Ajout de note impossible");
			return true;
		}
		else
			return false;
	}

	/**
	 * Methode pour verifier qu'une note est correcte. Retourne
	 * true si c'est le cas, false sinon.
	 * 
	 * @param note
	 *            est la note a verifier.
	 */
	private boolean noteCorrecte(float note) {
		if ((note < MIN_NOTE) || (note > MAX_NOTE)) {
			System.out.println("Note incorrecte");
			return false;
		}
		else
			return true;
	}
	
	public float getMoyNotes() {
		return moyNotes;
	}
	
	public float getMaxNotes() {
		return maxNotes;		
	}
	
	public float getMinNotes() {
		return minNotes;
	}
	
	public int getNbNotes() {
		return nbNotes;
	}
}
