/* University of Strasbourg - Master ILC-ISI-RISE
 * Compilation Lab - Compiler for the arith language
 * Written by Cedric Bastoul cedric.bastoul@unistra.fr
 */

#include <stdbool.h>
#define SYMBOL_MAX_STRING 42

struct ast;

// Symbol table node
struct symbol {
  char* identifier;    // Symbol name
  bool  isconstant;    // true if the symbol is a constant, false otherwise
  int   value;         // Symbol value if the symbol is a constant
  struct symbol* next; // Next symbol in the NULL-terminated linked list
};

struct symbol* symbol_alloc();
void           symbol_free(struct symbol*);
struct symbol* symbol_new_temp(struct symbol**);
struct symbol* symbol_new_constant(struct symbol**, int);
struct symbol* symbol_lookup(struct symbol*, char*);
struct symbol* symbol_add(struct symbol**, char*);
void           symbol_build_table(struct ast*, struct symbol**);
void           symbol_print(struct symbol*);
