/* University of Strasbourg - Master ILC-ISI-RISE
 * Compilation Lab - Compiler for the arith language
 * Written by Cedric Bastoul cedric.bastoul@unistra.fr
 */

// Quad node
struct quad {
  char op;             // Operator
  struct symbol* arg1; // First argument
  struct symbol* arg2; // Second argument
  struct symbol* res;  // Result
  struct quad*   next; // Next quad in the NULL-terminated linked list
};

struct quad* quad_gen(char, struct symbol*, struct symbol*, struct symbol*);
void         quad_free(struct quad*);
void         quad_add(struct quad**, struct quad*);
void         quad_print(struct quad*);
