/* University of Strasbourg - Master ILC-ISI-RISE
 * Compilation Lab - Compiler for the arith language
 * Written by Cedric Bastoul cedric.bastoul@unistra.fr
 */

struct symbol;

// Instruction types
enum instruction_type {
  instruction_type_push,
  instruction_type_pop,
  instruction_type_print,
  instruction_type_add,
  instruction_type_mul
};

// Instruction node
struct instruction {
  enum instruction_type type; // Type of the instruction
  struct symbol* address;     // Address of the operand (if any)
  struct instruction* next;   // Next instruction in the linked list
};

struct instruction* instruction_generate(struct quad*);
void   instruction_free(struct instruction*);
void   instruction_print(struct instruction*);
void   instruction_print_memory_state(struct symbol*);
