/* University of Strasbourg - Master ILC-ISI-RISE
 * Compilation Lab - Compiler for the arith language
 * Written by Cedric Bastoul cedric.bastoul@unistra.fr
 */

#include <stdio.h>
#include <stdlib.h>
#include "symbol.h"
#include "quad.h"

// Create a new quad with fields set to corresponding parameters.
struct quad* quad_gen(char op, struct symbol* arg1, struct symbol* arg2,
                      struct symbol* res) {
  struct quad* new = malloc(sizeof(struct quad));
  new->op = op;
  new->arg1 = arg1;
  new->arg2 = arg2;
  new->res  = res;
  new->next = NULL;
  return new;
}

// Free the memory allocated for a quad list (but not the linked symbols).
void quad_free(struct quad* quad) {
  struct quad* next;
  while (quad != NULL) {
    next = quad->next;
    free(quad);
    quad = next;
  }
}

// Append the src quad list to the dest quad list.
void quad_add(struct quad** dest, struct quad* src) {
  if (*dest == NULL) {
    *dest = src;
  } else {
    struct quad* scan = *dest;
    while (scan->next != NULL)
      scan = scan->next;
    scan->next = src;
  }
}

// Print a quad list.
void quad_print(struct quad* quad){
  printf("OP    ARG1    ARG2     RES\n");
  while (quad != NULL) {
    printf(" %c ", quad->op);
    if (quad->arg1 == NULL)
      printf("   NULL ");
    else
      printf("%7s ", quad->arg1->identifier);
    if (quad->arg2 == NULL)
      printf("   NULL ");
    else
      printf("%7s ", quad->arg2->identifier);
    if (quad->res == NULL)
      printf("   NULL\n");
    else
      printf("%7s\n", quad->res->identifier);
    quad = quad->next;
  }
}
