/* University of Strasbourg - Master ILC-ISI-RISE
 * Compilation Lab - Compiler for the arith language
 * Written by Cedric Bastoul cedric.bastoul@unistra.fr
 */

// AST node types
enum ast_type {
  ast_type_add,
  ast_type_mul,
  ast_type_statement,
  ast_type_number,
  ast_type_identifier,
};

// AST generic node
struct ast {
  enum ast_type type;         // Type of the AST node
  union {                     // Node data depending on the AST type:
    struct {                  // - Operation (add and mul)
      struct ast* left;       //   -- Left  hand side of the operation
      struct ast* right;      //   -- Right hand side of the operation
    } operation;
    struct {                  // - Statement (assignment and print)
      char* identifier;       //   -- Identifier name (NULL if print type)
      struct ast* expression; //   -- Right hand side of the statement
      struct ast* next;       //   -- Next statement in the linked list
    } statement;
    int number;               // - Number
    char* identifier;         // - Identifier name
  } u;
};

struct ast* ast_new_operation(enum ast_type, struct ast*, struct ast*);
struct ast* ast_new_number(int);
struct ast* ast_new_statement(char*, struct ast*);
struct ast* ast_new_identifier(char*);
struct ast* ast_concat(struct ast*, struct ast*);
void        ast_free(struct ast*);
void        ast_print(struct ast*, int);
