/* University of Strasbourg - Master ILC-ISI-RISE
 * Compilation Lab - Compiler for the arith language
 * Written by Cedric Bastoul cedric.bastoul@unistra.fr
 */

%{
  #include <stdlib.h>
  #include <string.h>
  #include "y.tab.h"
%}

comment    "//".*$
identifier [a-zA-Z_]+[0-9a-zA-Z_]*
number     0|[1-9]+[0-9]*

%%

{comment}    { }
print        { return PRINT; }
{identifier} { yylval.string = strdup(yytext); return IDENTIFIER; }
{number}     { yylval.value = atoi(yytext); return NUMBER; }
[()+*=;]     { return yytext[0]; }
[ \t\n]      { }
.            { printf("[L] ERROR: unknown character %s\n", yytext); }

%%

// Free the memory allocated for Lex when we are done.
void lex_free() {
  yy_delete_buffer(YY_CURRENT_BUFFER);
  free(yy_buffer_stack);
}
