/* University of Strasbourg - Master ILC-ISI-RISE
 * Compilation Lab - Compiler for the arith language
 * Written by Cedric Bastoul cedric.bastoul@unistra.fr
 */

%{
  #include <stdio.h>  
  #include <stdlib.h>
%}

comment    "//".*$
identifier [a-zA-Z_]+[0-9a-zA-Z_]*
number     0|[1-9]+[0-9]*

%%

{comment}    { printf("[L] comment:    %s\n", yytext); }
print        { printf("[L] keyword:    %s\n", yytext); }
{identifier} { printf("[L] identifier: %s\n", yytext); }
{number}     { printf("[L] number:     %s\n", yytext); }
[()+*=;]     { printf("[L] symbol:     '%s'\n", yytext); }
[ \t\n]      { }
.            { printf("[L] ERROR: unknown character %s\n", yytext); }

%%

int main() {
  yylex();
  return 0;
}
