/*     cassage de domaine
*/

/* Saisit n (tq T^n=Id), T et le domaine En */

#include <stdio.h>
#include <stdlib.h>
#include "types.h"
#include "vector.h"
#include "polyhedron.h"
#include "polyparam.h"

#define WS 1000
#define AFF_POLY(P) {	fprintf( stderr, "\n"#P" = "); \
                        Polyhedron_Print( stderr, "%3d ", P ); }

#define AFFCONTRAINTES(p) {	printf( "\n# "#p "\n" ); \
                        AffContraintes( p ); }

void AffContraintes( Polyhedron *p )
{
	int i,j;
	for( ; p ; p=p->next )
	{
		printf( "%d %d\n", p->NbConstraints, p->Dimension+2 );
		for( i=0 ; i<p->NbConstraints ; i++ )
		{
			for( j=0 ; j<p->Dimension+2 ; j++ )
				printf( "%d ", p->Constraint[i][j] );
			printf( "\n" );
		}
	}
}
int main(int argc, char *argv[])
{
	int n, k, s;
	Matrix *r1, *r2, *ri;
	Matrix *T, *nTk, *en, *c, *context, **Tk;
	Polyhedron *E, *L, *Lt, *E2, *L2, *EE, *D, *C, *Ci, *Cn;
	int i,j,l, lex, ll;

	scanf( "%d", &n );

/*	T = Matrix_Read(); */
	r1 = Matrix_Read();
	r2 = Matrix_Read();
	s = r1->NbColumns;
	if( s != r2->NbColumns || s != r2->NbRows || s != r1->NbRows )
	{
		fprintf(stderr,
		"Les matrices r1 et r2 doivent etre carrees et avoir la meme taille\n" );
		exit(0);
	}
	ri = Matrix_Alloc(s, s+1);
	if( !MatInverse( r2, ri ) )
	{
		fprintf( stderr, "r2 non inversible!\n");
		exit(0);
	}
/*	r2i = Matrix_Alloc( s, s );
	for( i=0 ; i<s ; i++ )
	{
		if( ri->p[i][s] != 1 )
		{
			fprintf(stderr, "La matrice r1 doit etre unimodulaire\n" );
			exit(0);
		}
		for( j=0; j<s ; j++ )
			r2i->p[i][j] = ri->p[i][j];
	}
	Matrix_Free( ri );
	T = Matrix_Alloc(s, s );
	Matrix_Product( r2i, r1, T );
	Matrix_Free( r2i );
*/
	T = Matrix_Alloc(s, s );
	for( i=0 ; i<s ; i++ )
		for( j=0 ; j<s ; j++ )
		{
			int z,k;
			z=0;
			for( k=0 ; k<s ; k++ )
				z += ri->p[i][k] * r1->p[k][j];
			if( z % ri->p[i][s] != 0 )
			{
				fprintf(stderr,
					"Les matrices r1 et r2 n'ont pas le meme determinant\n" );
				exit(0);
			}
			T->p[i][j] = z / ri->p[i][s];
		}
	Matrix_Free( ri );
	Matrix_Free( r1 );
	Matrix_Free( r2 );

	en = Matrix_Read();
	D = Constraints2Polyhedron(en, WS );
	Matrix_Free(en);

	context = Matrix_Read();


	if( T->NbColumns != D->Dimension+1 || T->NbColumns != T->NbRows )
	{
		fprintf(stderr,
		"Matrice T non carree ou incompatible avec la dimension de D !\n" );
		exit(0);
	}

	/* calcul des T^k, 1 <= k <= n */
	Tk = (Matrix **) malloc( (n+1)*sizeof(Matrix *) );
	/* initialise Tk = Id */
	Tk[0] = Matrix_Alloc(T->NbRows, T->NbColumns);
	for( i=0 ; i<T->NbRows ; i++ )
		for( j=0 ; j<T->NbColumns ; j++ )
			if( i!=j )
				Tk[0]->p[i][j]=0;
			else
				Tk[0]->p[i][j]=1;
	for( l=1 ; l<=n ; l++ )
	{
		Tk[l] = Matrix_Alloc(T->NbRows, T->NbColumns);
		Matrix_Product( Tk[l-1], T, Tk[l] );
		fprintf(stderr, "T^%d = ",l);
		Matrix_Print( stderr, "%3d ", Tk[l]);
	}

	/* calcul de C */
	C = DomainIntersection( 
			DomainIntersection( D, DomainPreimage(D,T,WS), WS),
			DomainImage(D,T,WS),
			WS);
	/* calcul de En = C \cap T^-1 C \cap ... \cap T^-(n-1) C */
/*	E = EE = C;
	for( k=1 ; k<=n-1 ; k++ )
	{
		EE = DomainPreimage(EE,T,WS);
		E = DomainIntersection( EE, E, WS );
	}	*/
	/* sortie pour visudomain : */
/*	AFFCONTRAINTES(E); */

	nTk = Matrix_Alloc( T->NbRows, T->NbColumns );
	c = Matrix_Alloc( T->NbRows, T->NbColumns+1 );
	for( l=1 ; l<=n ; l++ )
	{
		/* calcule E = { x | T^l x = x } */
		c->NbRows = T->NbRows;
		for( i=0 ; i<T->NbRows ; i++ )
		{
			c->p[i][0] = 0;
			memcpy( &c->p[i][1], &Tk[l]->p[i][0], T->NbColumns*sizeof(int) );
			c->p[i][i+1] --;	/* T^l - Id */
		}
		Ci = DomainAddConstraints( C, c, WS );

		/* reduit Ci tel que tous les points par les images T^l sont dans C */
		EE = Ci;
		for( k=1 ; k<=l ; k++ )
		{
			EE = DomainPreimage(EE,T,WS);
			Ci = DomainIntersection( EE, Ci, WS );
		}

		/* pas de nouveaux points ? */
		if( emptyQ(Ci) )
		{
			printf( "\n# empty C%d\n",l);
			continue;	/* passe au l suivant */
		}

		/* C = C \ Ci */
		Cn = DomainDifference( C, Ci, WS );
		Domain_Free( C );
		C = Cn;

		/* affiche Ci */
/* NON!
		printf( "#i=%d, ", l );
		AFFCONTRAINTES( Ci );
*/


		/* decompose Ci en sous domaines : calcule E */
		E = Ci;
		/* calcule L = { T x > x, T^2 x>x, ..., T^(l-1) x>x} */
		for( k=1 ; k<=l-1 ; k++ )
		{
			/* copie Tk[k] dans nTk */
			memcpy( nTk->p_Init, Tk[k]->p_Init, T->NbRows*T->NbColumns*sizeof(int) );
			/* nTk = Tk-Id */
			for( i=0 ; i<T->NbRows ; i++ )
				nTk->p[i][i] --;
			/* Cree le domaine { nTk x > 0 (lexico.) } */
			L=NULL;
			for( lex=0 ; lex<nTk->NbRows-1 ; lex++ )
			{
				c->NbRows = lex+1;
				/* 'lex' egalites */
				for( ll=0 ; ll<lex ; ll++ )
				{
					c->p[ll][0] = 0;
					memcpy( &c->p[ll][1], &nTk->p[ll][0], T->NbColumns*sizeof(int) );
				}
				/* et une inegalite */
				c->p[ll][0] = 1;
				memcpy( &c->p[ll][1], &nTk->p[ll][0], T->NbColumns*sizeof(int) );
				c->p[ll][T->NbColumns] --;  /* STRICTE ! */
				Lt = Constraints2Polyhedron( c, WS );

				if( !L )
					L = Lt;
				else
				{
					L2 = DomainUnion( L, Lt, WS );
					Domain_Free( L );
					Domain_Free( Lt );
					L = L2;
				}
			}
			/* ajoute les contraintes min lexico a E */
			E2 = DomainIntersection( E, L, WS );
			Domain_Free( E );
			Domain_Free( L );
			E = E2;
		}

		/* affiche E, puis les autres sous domaines (T E, T^2 E, ...) */
		AFF_POLY( E );
		printf( "# E%d,%d", l, 0 );
		AFFCONTRAINTES(E);
		for( k=1 ; k<l ; k++ )
		{
			EE = DomainImage(E,T,WS);
			Domain_Free( E );
			E = EE;
			printf( "# E%d,%d", l, k );
			AFFCONTRAINTES( EE );
		}
		Domain_Free( E );
	}

	printf( "# Reste de C" );
	AFFCONTRAINTES( C );

	if( argc==2 )
	{
		if( strcmp(argv[1],"-nocontext") )
		{
			printf("#context\n");
			Matrix_Print( stdout, "%3d ", context);
		}
	}
	else
	{
		printf("#context\n");
		Matrix_Print( stdout, "%3d ", context);
	}

	/* il faudrait faire des free ici */
	return 0;
}

