/*  input : t1 trans (homogeneous)
            t2 trans (homogeneous)
            D1 polyhedron
            D2 polyhedron
				C Context
	output : loop scanning T2^-1 T1 D1, T1^-1 T2 D2 and their intersection
*/

#include <stdio.h>
#include <polylib/polylib32.h>


int main()
{
    Matrix *b, *t1, *t2, *con;
    Polyhedron *D1, *D2, *S12, *S1p2,  *Con;
	Polyhedron *Tm2 /* , *Tm1 */, *p ;

    t1 = Matrix_Read();
    t2 = Matrix_Read();

    b = Matrix_Read();
    D1 = Constraints2Polyhedron(b, 200);
    Matrix_Free(b);
    b = Matrix_Read();
    D2 = Constraints2Polyhedron(b, 200);
    Matrix_Free(b);

	con = Matrix_Read();
	Con = Constraints2Polyhedron(con, 200);


	Tm2 = DomainPreimage(DomainImage(D1,t1,200),t2,200);
	printf( " T2^-1 T1 D1 =\n");
    Matrix_Print( stdout, "%4d ", Polyhedron2Constraints(Tm2) );

/*	printf( " T1^-1 T2 D = ");
    Polyhedron_Print( stdout, "%4d ", Tm1 );
*/

/*	S12 = DomainIntersection( Tm1, DomainIntersection( Tm2, D, 200 ), 200 );
    printf("\n S12 = D \\inter T2^-1 T1 D \\inter T1^-1 T2 D = ");
    Matrix_Print( stdout, "%4d ", Polyhedron2Constraints(S12));
	Polyhedron_Print( stdout, "%4d ", Polyhedron_Scan( S12, Con, 200 ) );

	S12p = DomainDifference( DomainIntersection(Tm1, D, 200), Tm2, 200 );
    printf("\n S12' = " );
    Matrix_Print( stdout, "%4d ", Polyhedron2Constraints(S12p));
	Polyhedron_Print( stdout, "%4d ", Polyhedron_Scan( S12p, Con, 200 ) );

	S1p2 = DomainDifference( DomainIntersection(Tm2, D, 200), Tm1, 200 );
    printf("\n S1'2 = " );
    Matrix_Print( stdout, "%4d ", Polyhedron2Constraints(S1p2));
	Polyhedron_Print( stdout, "%4d ", Polyhedron_Scan( S1p2, Con, 200 ) );

	S1p2p = DomainDifference( D, DomainUnion(Tm1, Tm2, 200), 200 );
    printf("\n S1'2' = " );
    Matrix_Print( stdout, "%4d ", Polyhedron2Constraints(S1p2p));
	Polyhedron_Print( stdout, "%4d ", Polyhedron_Scan( S1p2p, Con, 200 ) );
*/
	S12 = DomainIntersection( D2, Tm2, 200 );
    printf("\n D2 \\inter T2^-1 T1 D1 =\n");
    Matrix_Print( stdout, "%4d ", Polyhedron2Constraints(S12) );
	printf( "SCAN : " );
	Polyhedron_Print( stdout, "%4d ", Polyhedron_Scan( S12, Con, 200 ) );

	S1p2 = DomainDifference( D2, S12, 200 );
	printf("\n Reste =\n" );
	for( p=S1p2 ; p ; p = p->next )
	{
		Matrix_Print( stdout, "%4d ", Polyhedron2Constraints(p) );
		if( p->next )
			printf( "UNION\n");
	}
	for( ; S1p2 ; S1p2 = p )
	{
		printf( "SCAN : " );
		p = S1p2->next;
		S1p2->next = NULL;
		Polyhedron_Print( stdout, "%4d ", Polyhedron_Scan( S1p2, Con, 200 ) );
	}

    Domain_Free(D1);
    Domain_Free(D2);

    return 0;
}


