/*
     COPYRIGHT
          Both this software and its documentation are
 
              Copyrighted 1997 by Vincent Loechner.
              GTK Code 1999 by Stephane Genaud.

          Permission is granted to copy, use, and distribute
          for any commercial or noncommercial purpose under the terms
          of the GNU General Public license, version 2, June 1991
          (see file : LICENSING).
*/
#include <gtk/gtk.h>
#include <gdk/gdk.h>


/***********************************************/
/* reads a domain from stdin and visualize it  */
/***********************************************/

/* INPUT :     # union of domains :
               <d1>
               
               <d2>
               
               ...
               

               # context :
               <context>
					
               # (optional) parameter names
               M1 M2
					
               # (optional) window name
               wname

	<d1>, <d2>, ... and <context> are polyhedra (PolyLib format)
	M1, M2, ... are strings, separated by white space, tabs, or CR.
	wname is a string
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <polylib/polylib32.h>
#include "visual.h"


int main( int argc, char **argv )	
{
	Matrix *pm;
	Polyhedron *P, *ptmp, *C;
	unsigned NbRows, NbColumns;
	char s[256], param[50];
	char **param_name;
	int i, j, c, f;


	P = NULL;
	pm = Matrix_Read();
	f=1;
	while( f )
	{
		do
		{
			if( fgets(s, 1024, stdin) == 0  )
				f=0;
		}
		while ( (*s=='#' || *s=='\n') && f );

		if( f && sscanf(s, "%d %d", &NbRows, &NbColumns)==2 )
		{
			/* recupere l'ancien pm et l'ajoute a la liste de matrices */
			if( P )
				if( pm->NbColumns != P->Dimension+2 )
				{
					fprintf( stderr,
						"Polyhedra must be in the same dimension space !\n");
					exit(0);
				}
			ptmp = Constraints2Polyhedron(pm, 200);
			ptmp->next = P;
			P = ptmp;
			Matrix_Free(pm);

			/* lit la nouvelle matrice en entree */
			pm = Matrix_Alloc(NbRows, NbColumns);
			Matrix_Read_Input( pm );
		}
		else
			break;
	}

	C = Constraints2Polyhedron(pm, 200);
	Matrix_Free(pm);


	if( f )
	{
		/* lecture des noms des parametres */
		param_name = (char **)malloc( C->Dimension*sizeof(char *) );
		c = 0;
		for( i=0 ; i<C->Dimension ; ++i )
		{
			j=0;
			for( ; ; ++c )
			{
				if( s[c]==' ' || s[c]=='\n' || s[c]==0 ) {
					if( j==0 )
						continue;
					else
						break;
				}
				param[j++] = s[c];
			}

			/* si pas assez de parametres, fin (parametres par defaut) */
			if( j==0 )
				break;
			param[j] = 0;
			param_name[i] = (char *)malloc( j );
			strcpy( param_name[i], param );
		}
		if( i != C->Dimension )
		{
			free( param_name );
			param_name = NULL;
		}
	}
	else
		param_name = NULL;

	f=1;
	do
	{	if( fgets(s, 1024, stdin) == 0  )
			f=0;
	}
	while ( (*s=='#' || *s=='\n') && f );
	if( !f )
		strcpy( s, argv[0] );

	gtk_init(&argc,&argv);
	DomVisual( P, C, param_name, s );
	return(1);
}

